﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;

namespace _3dIntermediateFileLibraryTest
{
    /// <summary>
    /// マテリアルアニメーションの結合テストです。
    /// </summary>
    [TestClass]
    public class CombineMaterialAnimTest
    {
        /// <summary>
        /// 同名マテリアルがあり、引数ファイルが持っていないアニメーションを結合ファイルから結合するテストです。
        /// </summary>
        [TestMethod]
        public void TestCombineMaterialAnim()
        {
            material_animType matAnimArg = new material_animType()
            {
                material_anim_info = new material_anim_infoType(),
                per_material_anim_array = new per_material_anim_arrayType()
                {
                    per_material_anim = new per_material_animType[1]
                    {
                        new per_material_animType()
                        {
                            shader_param_anim_array = new shader_param_anim_arrayType()
                            {
                                param_anim = new param_animType[1]
                                {
                                    new param_animType()
                                    {
                                        id = "specular"
                                    }
                                }
                            },
                            tex_pattern_anim_array = new tex_pattern_anim_arrayType()
                            {
                                pattern_anim = new pattern_anim_targetType[1]
                                {
                                    new pattern_anim_targetType()
                                    {
                                        sampler_name = "sampler0"
                                    }
                                }
                            }
                        }
                    }
                },
                original_per_material_anim_array = new original_per_material_anim_arrayType()
                {
                    original_per_material_anim = new original_material_animType[1]
                    {
                        new original_material_animType()
                        {
                            original_color_anim_array = new original_color_anim_arrayType()
                            {
                                original_color_anim = new original_color_animType[1]
                                {
                                    new original_color_animType()
                                    {
                                        hint = "color0",
                                        original_color_anim_target = new original_color_anim_targetType[1]
                                        {
                                            new original_color_anim_targetType()
                                        }
                                    }
                                }
                            },
                            original_texsrt_anim_array = new original_texsrt_anim_arrayType()
                            {
                                original_texsrt_anim = new original_texsrt_animType[1]
                                {
                                    new original_texsrt_animType()
                                    {
                                        hint = "_a0",
                                        original_texsrt_anim_target = new original_texsrt_anim_targetType[1]
                                        {
                                            new original_texsrt_anim_targetType()
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };

            material_animType matAnimCombine = new material_animType()
            {
                material_anim_info = new material_anim_infoType(),
                per_material_anim_array = new per_material_anim_arrayType()
                {
                    per_material_anim = new per_material_animType[1]
                    {
                        new per_material_animType()
                        {
                            shader_param_anim_array = new shader_param_anim_arrayType()
                            {
                                param_anim = new param_animType[1]
                                {
                                    new param_animType()
                                    {
                                        id = "diffuse",
                                        param_anim_target = new param_anim_targetType[1]
                                        {
                                            new param_anim_targetType()
                                        }
                                    }
                                }
                            },
                            tex_pattern_anim_array = new tex_pattern_anim_arrayType()
                            {
                                pattern_anim = new pattern_anim_targetType[1]
                                {
                                    new pattern_anim_targetType()
                                    {
                                        sampler_name = "sampler1"
                                    }
                                }
                            }
                        }
                    }
                },
                original_per_material_anim_array = new original_per_material_anim_arrayType()
                {
                    original_per_material_anim = new original_material_animType[1]
                    {
                        new original_material_animType()
                        {
                            original_color_anim_array = new original_color_anim_arrayType()
                            {
                                original_color_anim = new original_color_animType[1]
                                {
                                    new original_color_animType()
                                    {
                                        hint = "color1",
                                        original_color_anim_target = new original_color_anim_targetType[1]
                                        {
                                            new original_color_anim_targetType()
                                        }
                                    }
                                }
                            },
                            original_texsrt_anim_array = new original_texsrt_anim_arrayType()
                            {
                                original_texsrt_anim = new original_texsrt_animType[1]
                                {
                                    new original_texsrt_animType()
                                    {
                                        hint = "_a1",
                                        original_texsrt_anim_target = new original_texsrt_anim_targetType[1]
                                        {
                                            new original_texsrt_anim_targetType()
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };

            IfMaterialAnimCombineUtility.Combine(
                matAnimArg,
                new System.Collections.Generic.List<G3dStream>(),
                new CombineInfo[1] { new CombineInfo(string.Empty, matAnimCombine, null) },
                new CombineSettings());

            // シェーダーパラメーターアニメーション結合結果のチェック
            Assert.AreEqual(
                2,
                matAnimArg.per_material_anim_array.per_material_anim[0].shader_param_anim_array.param_anim.Length);
            Assert.AreEqual(
                "specular",
                matAnimArg.per_material_anim_array.per_material_anim[0].shader_param_anim_array.param_anim[0].id);
            Assert.AreEqual(
                "diffuse",
                matAnimArg.per_material_anim_array.per_material_anim[0].shader_param_anim_array.param_anim[1].id);

            // テクスチャーパターンアニメーション結合結果のチェック
            Assert.AreEqual(
                2,
                matAnimArg.per_material_anim_array.per_material_anim[0].tex_pattern_anim_array.pattern_anim.Length);
            Assert.AreEqual(
                "sampler0",
                matAnimArg.per_material_anim_array.per_material_anim[0].tex_pattern_anim_array.pattern_anim[0].sampler_name);
            Assert.AreEqual(
                "sampler1",
                matAnimArg.per_material_anim_array.per_material_anim[0].tex_pattern_anim_array.pattern_anim[1].sampler_name);

            // オリジナルカラーアニメーション結合結果のチェック
            Assert.AreEqual(
                2,
                matAnimArg.original_per_material_anim_array.original_per_material_anim[0].original_color_anim_array.original_color_anim.Length);
            Assert.AreEqual(
                "color0",
                matAnimArg.original_per_material_anim_array.original_per_material_anim[0].original_color_anim_array.original_color_anim[0].hint);
            Assert.AreEqual(
                "color1",
                matAnimArg.original_per_material_anim_array.original_per_material_anim[0].original_color_anim_array.original_color_anim[1].hint);

            // オリジナルテクスチャ SRT アニメーション結合結果のチェック
            Assert.AreEqual(
                2,
                matAnimArg.original_per_material_anim_array.original_per_material_anim[0].original_texsrt_anim_array.original_texsrt_anim.Length);
            Assert.AreEqual(
                "_a0",
                matAnimArg.original_per_material_anim_array.original_per_material_anim[0].original_texsrt_anim_array.original_texsrt_anim[0].hint);
            Assert.AreEqual(
                "_a1",
                matAnimArg.original_per_material_anim_array.original_per_material_anim[0].original_texsrt_anim_array.original_texsrt_anim[1].hint);

        }
    }
}
