﻿using System;
using System.Linq;
using System.Text;
using G3dCombinerShaderConverter;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace _3dCombinerShaderConverterTest
{
    [TestClass]
    public class GlslUtilityTest
    {
        [TestMethod]
        public void ExtractIncludeFiles()
        {
            StringBuilder sourceCode = new StringBuilder();
            sourceCode.AppendLine("#if 0");
            sourceCode.AppendLine("#endif");
            sourceCode.AppendLine("#include<hoge.h>");
            sourceCode.AppendLine("  #  include   \"fuga.h\"");
            sourceCode.AppendLine("//#include <piyo.h>");
            var includeFiles = GlslUtility.ExtractIncludeFilePaths(sourceCode.ToString());
            Assert.AreEqual(2, includeFiles.Count());
            Assert.AreEqual("hoge.h", includeFiles.ElementAt(0));
            Assert.AreEqual("fuga.h", includeFiles.ElementAt(1));
        }
    }
}
