﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;
using System.Linq;

namespace G3dLibraryTest
{
    [TestClass]
    public class ShapeAnimTest
    {
        [TestMethod]
        public void ShapeAnimStreamReferenceTest()
        {
            var sourceFile = new IntermediateFile(IntermediateFileKind.ShapeAnim);
            var rootAnim = sourceFile.GetRootEntity<ShapeAnim>();
            rootAnim.Streams.Add(new StreamFloat());
            rootAnim.Streams.Add(new StreamFloat());

            {
                int streamIndex = 1;
                var anim = new VertexShapeAnim();
                rootAnim.VertexShapeAnims.Add(anim);
                Assert.IsNotNull(anim.Parent);

                var target = new ShapeAnimTarget();
                anim.ShapeAnimTargets.Add(target);
                Assert.IsNotNull(target.Parent);

                var curve = new LinearCurve();
                target.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                curve.Stream = rootAnim.Streams[streamIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as shape_animType).vertex_shape_anim_array.Items[0].shape_anim_target.Length);
                Assert.AreEqual(streamIndex, (writeData.Item as shape_animType).vertex_shape_anim_array.Items[0].shape_anim_target[0].Curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<ShapeAnim>().VertexShapeAnims[0].ShapeAnimTargets[0].Curve.Stream);
            }
        }
    }
}
