﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Reflection;
using nw.g3d.nw4f_3dif;
using nw.g3d.iflib;
using Nintendo.G3dTool.Entities;
using _3dToolsTestUtility;
using System.IO;

namespace G3dLibraryTest
{
    [TestClass]
    public class ReadWriteFileTest
    {
        [TestMethod]
        public void ReadWriteG3dDemoFmdb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fmdb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFmtb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fmtb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFtxb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.ftxb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFskb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fskb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFmab()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fmab"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFvbb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fvbb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFshb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fshb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFsnb()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fsnb"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFsca()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fsca"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFsva()
        {
            ReadWriteTestImpl(FindG3dDemoPath("*.fsva"));
        }
        [TestMethod]
        public void ReadWriteG3dDemoFsdb()
        {
            string assemblyFolder = System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            ReadWriteTestImpl(System.IO.Directory.EnumerateFiles(System.IO.Path.Combine(assemblyFolder, "Resources"), "*.fsdb", System.IO.SearchOption.AllDirectories));
        }

        private IEnumerable<string> FindG3dDemoPath(params string[] testFileNamePatterns)
        {
            string g3dDemoResourceRoot = System.IO.Path.Combine(_3dToolsTestUtility.IoUtility.GetG3dDemoRootPath(), "Resources");
            foreach (string pattern in testFileNamePatterns)
            {
                foreach (var filePath in System.IO.Directory.EnumerateFiles(g3dDemoResourceRoot, pattern, System.IO.SearchOption.AllDirectories))
                {
                    yield return filePath;
                }
            }
        }

        private void ReadWriteTestImpl(IEnumerable<string> filePaths)
        {
            G3dParallel.Job = 1;
            foreach (string fmdFile in filePaths)
            {
                string tempFolder = IoUtility.GetTempFolderPath();
                System.IO.Directory.CreateDirectory(tempFolder);
                string tmpPath = System.IO.Path.Combine(tempFolder, System.IO.Path.GetFileName(fmdFile));

                Console.WriteLine($"Testing {tmpPath}");
                try
                {
                    var fileSource = IfReadUtility.ReadIntermediateFile(fmdFile, IoUtility.GetXsdBasePath());

                    using (var stream = new FileStream(tmpPath, FileMode.Create))
                    {
                        IfBinaryWriteUtility.WriteIntermediateFile(fileSource, stream, IoUtility.GetXsdBasePath());
                        stream.Seek(0, SeekOrigin.Begin);
                        var file = IfBinaryReadUtility.ReadIntermediateFile(stream, IoUtility.GetXsdBasePath());
                        Assert.IsNotNull(file.RootEntity);
                    }
                }
                finally
                {
                    if (System.IO.Directory.Exists(tempFolder))
                    {
                        System.IO.Directory.Delete(tempFolder, true);
                    }
                }
            }
        }
    }
}
