﻿using System;
using System.Linq;
using System.ComponentModel;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;

namespace G3dLibraryTest
{
    [TestClass]
    public class PropertyChangedTest
    {
        public delegate void EditPropertyDelegate(IEntity entity);

        [TestMethod]
        public void PropertyChangedModelFile()
        {
            IntermediateFile file = new IntermediateFile(IntermediateFileKind.Model);
            var model = file.GetRootEntity<Model>();
            var mat = new Material();
            model.Materials.Add(mat);
            var shaderParam = new ShaderParamFloat4();
            mat.ShaderAssign.ShaderParams.Add(shaderParam);
            var sampler = new Sampler();
            mat.Samplers.Add(sampler);

            PropertyChangedTestImpl(file, x => file.FileInfo.Create.ToolName = "hoge");
            PropertyChangedTestImpl(file, x => model.ModelInfo.UnitePosQuantize = true);
            PropertyChangedTestImpl(file, x => shaderParam.Value.X = 5.0f);
            PropertyChangedTestImpl(file, x => shaderParam.Value[1] = 1.0f);
            PropertyChangedTestImpl(file, x => sampler.Filter.Mag = filter_mag_minType.point);
            PropertyChangedTestImpl(file, x => sampler.Wrap.U = wrap_uvwType.mirror_once);
        }

        private void PropertyChangedTestImpl(IEntity checkTargetEntity, EditPropertyDelegate editPropDelegate)
        {
            checkTargetEntity.AutoCalc = true;
            checkTargetEntity.Reset();
            bool isPropChanged = false;
            PropertyChangedEventHandler handler = (object sender, System.ComponentModel.PropertyChangedEventArgs e) =>
            {
                isPropChanged = true;
            };
            checkTargetEntity.PropertyChanged += handler;
            Assert.IsFalse(checkTargetEntity.IsDirty);
            Assert.IsFalse(isPropChanged);
            editPropDelegate(checkTargetEntity);
            Assert.IsTrue(checkTargetEntity.IsDirty);
            Assert.IsTrue(isPropChanged);
            checkTargetEntity.PropertyChanged -= handler;
        }
    }
}
