﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;
using System.Linq;

namespace G3dLibraryTest
{
    [TestClass]
    public class MaterialAnimTest
    {
        [TestMethod]
        public void MaterialAnimStreamReferenceTest()
        {
            var sourceFile = new IntermediateFile(IntermediateFileKind.MaterialAnim);
            var matAnim = sourceFile.GetRootEntity<MaterialAnim>();
            matAnim.Streams.Add(new StreamFloat());
            matAnim.Streams.Add(new StreamFloat());
            matAnim.Streams.Add(new StreamFloat());
            matAnim.Streams.Add(new StreamFloat());

            var perMatAnim = new PerMaterialAnim();
            matAnim.PerMaterialAnims.Add(perMatAnim);
            Assert.IsNotNull(perMatAnim.Parent);

            // シェーダーパラメーターアニメーション
            {
                int streamIndex = 1;
                var anim = new ParamAnim();
                perMatAnim.ParamAnims.Add(anim);
                Assert.IsNotNull(anim.Parent);

                var target = new ParamAnimTarget();
                anim.ParamAnimTargets.Add(target);
                Assert.IsNotNull(target.Parent);

                var curve = new LinearCurve();
                target.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                curve.Stream = matAnim.Streams[streamIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as material_animType).per_material_anim_array.Items[0].shader_param_anim_array.Items.Length);
                Assert.AreEqual(1, (writeData.Item as material_animType).per_material_anim_array.Items[0].shader_param_anim_array.Items[0].param_anim_target.Length);
                Assert.AreEqual(streamIndex, (writeData.Item as material_animType).per_material_anim_array.Items[0].shader_param_anim_array.Items[0].param_anim_target[0].Curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<MaterialAnim>().PerMaterialAnims[0].ParamAnims[0].ParamAnimTargets[0].Curve.Stream);
            }

            // パターンアニメーション
            {
                int streamIndex = 2;
                var anim = new PatternAnim();
                perMatAnim.PatternAnims.Add(anim);
                Assert.IsNotNull(anim.Parent);

                var curve = new StepCurve();
                anim.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                // ステップカーブ以外が設定できないことをチェック
                {
                    bool isErrorOccurred = false;
                    try
                    {
                        anim.Curve = new LinearCurve();
                    }
                    catch
                    {
                        isErrorOccurred = true;
                    }
                    Assert.IsTrue(isErrorOccurred);
                }

                curve.Stream = matAnim.Streams[streamIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as material_animType).per_material_anim_array.Items[0].tex_pattern_anim_array.Items.Length);
                Assert.AreEqual(streamIndex, (writeData.Item as material_animType).per_material_anim_array.Items[0].tex_pattern_anim_array.Items[0].step_curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<MaterialAnim>().PerMaterialAnims[0].PatternAnims[0].Curve.Stream);
            }

            // マテリアルビジビリティーアニメーション
            {
                int streamIndex = 3;
                var anim = new MaterialVisibilityAnim();
                perMatAnim.MaterialVisibilityAnim = anim;
                Assert.IsNotNull(anim.Parent);

                var curve = new StepCurve();
                anim.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                // ステップカーブ以外が設定できないことをチェック
                {
                    bool isErrorOccurred = false;
                    try
                    {
                        anim.Curve = new LinearCurve();
                    }
                    catch
                    {
                        isErrorOccurred = true;
                    }
                    Assert.IsTrue(isErrorOccurred);
                }

                curve.Stream = matAnim.Streams[streamIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.IsNotNull((writeData.Item as material_animType).per_material_anim_array.Items[0].material_visibility_anim);
                Assert.AreEqual(streamIndex, (writeData.Item as material_animType).per_material_anim_array.Items[0].material_visibility_anim.step_curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<MaterialAnim>().PerMaterialAnims[0].MaterialVisibilityAnim.Curve.Stream);
            }
        }
    }
}
