﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;

namespace G3dLibraryTest
{
    [TestClass]
    public class ChoiceTest
    {
        [TestMethod]
        public void ShaderOptionChoiceTest()
        {
            {
                ShaderOptionChoice choice = new ShaderOptionChoice("1:ほげ,2:ふが,3:ぴよ");
                Assert.AreEqual(ShaderOptionChoiceType.Enum, choice.Type);
                Assert.AreEqual(3, choice.Values.Count);
                Assert.AreEqual("1", choice.Values[0].Value);
                Assert.AreEqual("2", choice.Values[1].Value);
                Assert.AreEqual("3", choice.Values[2].Value);
                Assert.AreEqual("ほげ", choice.Values[0].Label);
                Assert.AreEqual("ふが", choice.Values[1].Label);
                Assert.AreEqual("ぴよ", choice.Values[2].Label);
            }

            {
                ShaderOptionChoice choice = new ShaderOptionChoice("1,2,3");
                Assert.AreEqual(ShaderOptionChoiceType.Enum, choice.Type);
                Assert.AreEqual(3, choice.Values.Count);
                Assert.AreEqual("1", choice.Values[0].Value);
                Assert.AreEqual("2", choice.Values[1].Value);
                Assert.AreEqual("3", choice.Values[2].Value);
            }

            {
                ShaderOptionChoice choice = new ShaderOptionChoice("1");
                Assert.AreEqual(ShaderOptionChoiceType.Enum, choice.Type);
                Assert.AreEqual(1, choice.Values.Count);
                Assert.AreEqual("1", choice.Values[0].Value);
            }

            {
                ShaderOptionChoice choice = new ShaderOptionChoice("[1,3]");
                Assert.AreEqual(ShaderOptionChoiceType.IntRange, choice.Type);
                Assert.AreEqual(0, choice.Values.Count);
                Assert.AreEqual(1, choice.MinValue);
                Assert.AreEqual(3, choice.MaxValue);
            }

            {
                ShaderOptionChoice choice = new ShaderOptionChoice("bool");
                Assert.AreEqual(ShaderOptionChoiceType.Bool, choice.Type);
                Assert.AreEqual(0, choice.Values.Count);
            }
        }

        [TestMethod]
        public void RenderInfoChoiceTest()
        {
            {
                var choice = new RenderInfoIntChoice("1:ほげ,2:ふが,3:ぴよ");
                Assert.AreEqual(RenderInfoNumericChoiceType.List, choice.Type);
                Assert.AreEqual(3, choice.Values.Count);
                Assert.AreEqual(1, choice.Values[0].Value);
                Assert.AreEqual(2, choice.Values[1].Value);
                Assert.AreEqual(3, choice.Values[2].Value);
                Assert.AreEqual("ほげ", choice.Values[0].Label);
                Assert.AreEqual("ふが", choice.Values[1].Label);
                Assert.AreEqual("ぴよ", choice.Values[2].Label);
            }

            {
                var choice = new RenderInfoStringChoice("1,2,hoge:ほげ");
                Assert.AreEqual(3, choice.Values.Count);
                Assert.AreEqual("1", choice.Values[0].Value);
                Assert.AreEqual("2", choice.Values[1].Value);
                Assert.AreEqual("hoge", choice.Values[2].Value);
                Assert.AreEqual("ほげ", choice.Values[2].Label);
            }

            {
                var choice = new RenderInfoFloatChoice("1");
                Assert.AreEqual(RenderInfoNumericChoiceType.List, choice.Type);
                Assert.AreEqual(1, choice.Values.Count);
                Assert.AreEqual(1.0f, choice.Values[0].Value);
            }

            {
                var choice = new RenderInfoFloatChoice("[0.0,1.0]");
                Assert.AreEqual(RenderInfoNumericChoiceType.Range, choice.Type);
                Assert.AreEqual(0, choice.Values.Count);
                Assert.AreEqual(0.0f, choice.MinValue);
                Assert.AreEqual(1.0f, choice.MaxValue);
            }
        }
    }
}
