﻿
// 全てのシェーダ

// fragment shader のみ
#ifdef NW_FRAGMENT_SHADER

uniform sampler2D albedoTex0;     // @@ id="albedo" hint="albedo0"
uniform sampler2D normalTex0;     // @@ id="normal" hint="normal0"

// @@ sampler_id="albedo" label="アルベドテクスチャ" group="group_basics"
// @@ sampler_id="normal" label="法線マップ" group="group_basics"

#endif

// uniform block の定義
// fragment shader のみ
#ifdef NW_FRAGMENT_SHADER

layout (std140) uniform Material // @@ id="material" type="material"
{
    vec4 diffuse;           // @@ id="diffuse" default="1 1 1 1" hint="diffuse" depend="factor_converter"
    vec4 specular;          // @@ id="specular" default="1 1 1 1" hint="specular"
    vec2 tex_sr_v0;         // @@ id="texsrt" type="texsrt" default ="0 1 1 0 0 0" hint="albedo0"
    vec2 tex_sr_v1;
    vec2 tex_translate;
    float factor;           // @@ id="factor" default="1"
    vec4 factor_converter;  // @@ id="factor_converter" default="1 1 1 1"
    float ambient;          // @@ id="ambient" default="1"
    
    // 以下、シェーダパラメータ編集テスト用データです。
    bool boolValue;         // @@ id="boolValue"
    bvec2 bool2Value;       // @@ id="bool2Value"
    bvec3 bool3Value;       // @@ id="bool3Value"
    bvec4 bool4Value;       // @@ id="bool4Value"
    
    int intValue;           // @@ id="intValue"
    ivec2 int2Value;        // @@ id="int2Value"
    ivec3 int3Value;        // @@ id="int3Value"
    ivec4 int4Value;        // @@ id="int4Value"
    int intCheck;           // @@ id="intCheck"
    
    uint uintValue;         // @@ id="uintValue"
    uvec2 uint2Value;       // @@ id="uint2Value"
    uvec3 uint3Value;       // @@ id="uint3Value"
    uvec4 uint4Value;       // @@ id="uint4Value"
    uint uintCheck;         // @@ id="uintCheck"
    
    float floatValue;       // @@ id="floatValue"
    vec2 vec2Value;         // @@ id="vec2Value"
    vec3 vec3Value;         // @@ id="vec3Value"
    vec4 vec4Value;         // @@ id="vec4Value"
    float floatCheck;       // @@ id="floatCheck"
    
    vec2 float2x2[2];       // @@ id="float2x2"
    vec3 float2x3[2];       // @@ id="float2x3"
    vec4 float2x4[2];       // @@ id="float2x4"
    vec2 float3x2[3];       // @@ id="float3x2"
    vec3 float3x3[3];       // @@ id="float3x3"
    vec4 float3x4[3];       // @@ id="float3x4"
    vec2 float4x2[4];       // @@ id="float4x2"
    vec3 float4x3[4];       // @@ id="float4x3"
    vec4 float4x4[4];       // @@ id="float4x4"
    
    vec2 srt2D_v0;          // @@ id="srt2d"
    vec2 srt2D_v1;
    vec2 srt2D_v2;
    vec4 srt3D_v1;          // @@ id="srt3d"
    vec4 srt3D_v2;
    vec4 srt3D_v3;
    vec2 srt_v0;            // @@ id="srt"
    vec2 srt_v1;
    vec2 srt_v2;
    // [廃止] vec4 srtEx[3];          // @@ id="srtEx"
};

// @@ uniform_id="diffuse"  min="0" max="1" item="color" label="ディフューズ" group="group_directional_light_diffuse"
// @@ uniform_id="specular" min="0" max="1" item="color" label="スペキュラー" group="group_directional_light" order="5"
// @@ uniform_id="texsrt" label="テクスチャ行列" group="group_basics"
// @@ uniform_id="factor"  min="0" max="1" label="カラーのファクター" group="group_basics"
// @@ uniform_id="factor_converter"  min="0" max="2" label="カラーのファクター（コンバータ経由）" group="group_basics"
// @@ uniform_id="ambient" min="0" max="1" label="アンビエント" group="group_hemisphere_light_ambient"

// @@ uniform_id="boolValue"  group="group_paramtest" default="0"       min="0" max="4" label="bool値:color{red}"
// @@ uniform_id="bool2Value" group="group_paramtest" default="0 0"     min="0" max="4" label="bool値 2D:color{red}"
// @@ uniform_id="bool3Value" group="group_paramtest" default="0 0 0"   min="0" max="4" label="bool値 3D:color{red}"
// @@ uniform_id="bool4Value" group="group_paramtest" default="0 0 0 0" min="0" max="4" label="bool値 4D:color{red}"
// @@ uniform_id="intValue"   group="group_paramtest" default="0"       min="-5" max="5" default_min="-2" default_max="3" label="int値（クランプ範囲とデフォルトのスライダ範囲設定済み）:background-color{pink}"
// @@ uniform_id="int2Value"  group="group_paramtest" default="0 0"     min="-5" max="5" label="int値 2D（クランプ範囲のみ設定）:background-color{pink}"
// @@ uniform_id="int3Value"  group="group_paramtest" default="0 0 0"   default_min="-2" default_max="3" label="int値 3D（デフォルトのスライダ範囲のみ設定）:background-color{pink}"
// @@ uniform_id="int4Value"  group="group_paramtest" default="0 0 0 0" min="-5" max="5" label="int値 4D:background-color{pink}"
// @@ uniform_id="intCheck"   group="group_paramtest" default="1" item="check" min="1" max="2" label="check(int):background-color{pink}"
// @@ uniform_id="uintValue"  group="group_paramtest" default="0"       min="0" max="4" label="uint値:color{#FF229022}"
// @@ uniform_id="uint2Value" group="group_paramtest" default="0 0"     min="0" max="4" label="uint値 2D:color{#FF229022}"
// @@ uniform_id="uint3Value" group="group_paramtest" default="0 0 0"   min="0" max="4" label="uint値 3D:color{#FF229022}"
// @@ uniform_id="uint4Value" group="group_paramtest" default="0 0 0 0" min="0" max="4" label="uint値 4D:color{#FF229022}"
// @@ uniform_id="uintCheck"  group="group_paramtest" default="1" item="check" min="1" max="2" label="check(uint):color{#FF229022}"
// @@ uniform_id="floatValue" group="group_paramtest" default="0"       min="0" max="1" label="float値:background-color{#FFEFD5}"
// @@ uniform_id="vec2Value"  group="group_paramtest" default="0 0"     min="0" max="1" label="vec2値:background-color{#FFEFD5}"
// @@ uniform_id="vec3Value"  group="group_paramtest" default="0 0 0"   min="0" max="1" label="vec3値:background-color{#FFEFD5}"
// @@ uniform_id="vec4Value"  group="group_paramtest" default="0 0 0 0" min="0" max="1" label="vec4値:background-color{#FFEFD5}"
// @@ uniform_id="floatCheck" group="group_paramtest" default="1" item="check" min="1" max="2" label="check(float):background-color{#FFEFD5}"
// @@ uniform_id="float2x2"   group="group_paramtest" type="float2x2" default="0 0 0 0" label="2x2 行列:background-color{LightCyan}"
// @@ uniform_id="float2x3"   group="group_paramtest" type="float2x3" default="0 0 0 0 0 0" label="2x3 行列:background-color{LightCyan}"
// @@ uniform_id="float2x4"   group="group_paramtest" type="float2x4" default="0 0 0 0 0 0 0 0" label="2x4 行列:background-color{LightCyan}"
// @@ uniform_id="float3x2"   group="group_paramtest" type="float3x2" default="0 0 0 0 0 0" label="3x2 行列:background-color{LightCyan}"
// @@ uniform_id="float3x3"   group="group_paramtest" type="float3x3" default="0 0 0 0 0 0 0 0 0" label="3x3 行列:background-color{LightCyan}"
// @@ uniform_id="float3x4"   group="group_paramtest" type="float3x4" default="0 0 0 0 0 0 0 0 0 0 0 0" label="3x4 行列:background-color{LightCyan}"
// @@ uniform_id="float4x2"   group="group_paramtest" type="float4x2" default="0 0 0 0 0 0 0 0" label="4x2 行列:background-color{LightCyan}"
// @@ uniform_id="float4x3"   group="group_paramtest" type="float4x3" default="0 0 0 0 0 0 0 0 0 0 0 0" label="4x3 行列:background-color{LightCyan}"
// @@ uniform_id="float4x4"   group="group_paramtest" type="float4x4" default="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0" label="4x4 行列:background-color{LightCyan}"
// @@ uniform_id="srt2d"      group="group_paramtest" type="srt2d" default ="1 1 0 0 0" label="SRT 2D:color{white}:background-color{black}"
// @@ uniform_id="srt3d"      group="group_paramtest" type="srt3d" default ="1 1 1 0 0 0 0 0 0" label="SRT 3D:color{white}:background-color{black}"
// @@ uniform_id="srt"        group="group_paramtest" type="texsrt" default ="0 1 1 0 0 0" label="テクスチャSRT:color{white}:background-color{black}"
// [廃止] uniform_id="srtEx"      group="group_paramtest" type="texsrt_ex" default ="0 1 1 0 0 0" label="テクスチャSRT Ex:color{white}:background-color{black}"

#endif
