﻿#version 330

#ifdef AGL_VERTEX_SHADER
#define NW_VERTEX_SHADER
#endif

#ifdef AGL_GEOMETRY_SHADER
#define NW_GEOMETRY_SHADER
#endif

#ifdef AGL_FRAGMENT_SHADER
#define NW_FRAGMENT_SHADER
#endif

// 全てのシェーダ

#define add +
#define sub -
#define mul *

#define nw_int_to_bool( condition ) ((condition) == 1)

#define USE_HEMISPHERE_LIGHT  (0) // @@ id="use_hemisphere_light"  choice="bool" type="static" enable="true" group="group_hemisphere_light"
#define USE_FOG               (0) // @@ id="use_fog"               choice="bool" type="static" enable="true" group="group_fog"
#define USE_DIRECTIONAL_LIGHT (0) // @@ id="use_directional_light" choice="bool" type="static" enable="true" group="group_directional_light"

#define FACTOR_FUNCTION       add // @@ id="factor_function" choice="add:加算, sub:減算, mul:乗算" type="static" group="group_basics"

layout(std140) uniform Options  // @@ id="option" type="option"
{
    int use_hemisphere_light;   // @@ id="use_hemisphere_light"
    int use_fog;                // @@ id="use_fog"
    int use_directional_light;  // @@ id="use_directional_light"
};

// @@ interleave="position normal" binarize="true"
// @@ interleave="" binarize="true"

// @@ page="page_renderinfo" label="描画情報" order="1"
// @@ page="page_test"       label="テスト"   order="2" comment="テスト用の項目です"

// @@ group="group_basics"            label="基本"
// @@ group="group_hemisphere_light"  label="半球ライト" condition="$use_hemisphere_light == true" order="5"
// @@ group="group_directional_light" label="指向性ライト" condition="$use_directional_light == true" order="5"
// @@ group="group_fog"               label="フォグ"     condition="$use_fog == true" order="5"
// @@ group="group_renderinfo" label="描画情報"          page="page_renderinfo"
// @@ group="group_paramtest"  label="パラメータテスト"  page="page_test"    comment="パラメータテスト用です" order="10"

// @@ group="group_lighting" label="ライティング" order="4"
/* @@ group_lighting:
    group_id="group_hemisphere_light"
    group_id="group_directional_light"
*/

// 空のラベルだと3DEditorのマテリアルプロパティウィンドウではただ改行されるだけになる
// @@ group="group_directional_light_diffuse" label="" order="5"
/* @@ group_directional_light:
    group_id="group_directional_light_diffuse"
*/

// @@ group="group_hemisphere_light_ambient" label="" order="4"
/* @@ group_hemisphere_light:
    group_id="group_hemisphere_light_ambient"
*/

// @@ renderinfo="render_priority" group="group_basics" type="int" label="描画優先度" default="255"
// @@ renderinfo="multi_category" group="group_renderinfo" type="string" label="多段構成" choice="0:キャラクター, 1:オブジェクト, 2:その他" default="0"
// @@ renderinfo="multi_list"     group="group_renderinfo" type="string" label="リスト" comment="接続時に「多段構成」にしたがって choice が変わります。"


// vertex shader のみ
#ifdef NW_VERTEX_SHADER

layout(location=0) in vec3 i_position0; // @@ id="position" hint="position0"
layout(location=1) in vec3 i_normal0;   // @@ id="normal"   hint="normal0"
layout(location=2) in vec4 i_tangent0;  // @@ id="tangent"  hint="tangent0"
layout(location=3) in vec4 i_binormal0; // @@ id="binormal" hint="binormal0"
layout(location=4) in ivec4 i_index0;   // @@ id="index"    hint="blendindex0"
layout(location=5) in vec4 i_weight0;   // @@ id="weight"   hint="blendweight0"
layout(location=6) in vec2 i_uv0;       // @@ id="uv"       hint="uv0"

// @@ attrib_id="position" label="座標"
// @@ attrib_id="normal"   label="法線"
// @@ attrib_id="tangent"  label="接線"
// @@ attrib_id="binormal" label="従法線"
// @@ attrib_id="index"    label="ウェイトインデクス"
// @@ attrib_id="weight"   label="ウェイト値"
// @@ attrib_id="uv"       label="UV"

out vec4 v_viewPos;
out vec3 v_normal;
out vec2 v_texcoord;
out vec4 v_color;

#endif

// fragment shader のみ
#ifdef NW_FRAGMENT_SHADER

in vec4 v_viewPos;
in vec3 v_normal;
in vec2 v_texcoord;
in vec4 v_color;

#endif

// uniform block の定義
// vertex shader のみ
#ifdef NW_VERTEX_SHADER

layout(std140) uniform Shapes // @@ id="shape" type="shape"
{
    vec4 world[3];
    int vertex_skinning_count;
};

layout(std140) uniform Bones  // @@ id="bone" type="skeleton"
{
    vec4 bone[256 * 3];
};

layout(std140) uniform Views  // @@ id="view" type="none"
{
    vec4 proj[4];
    vec4 view[3];
};

#endif

// fragment shader のみ
#ifdef NW_FRAGMENT_SHADER

layout (std140) uniform Env      // @@ id="env"
{
    vec4 hemiDir;                // @@ id="hemiDir"
    vec4 skyColor;               // @@ id="skyColor"
    vec4 groundColor;            // @@ id="groundColor"
    vec4 lightDir;               // @@ id="lightDir"
    vec4 diffuseColor;           // @@ id="diffuseColor"
    vec4 specularColor;          // @@ id="specularColor"
    float fogStart;              // @@ id="fogStart"
    float fogStartEndInv;        // @@ id="fogStartEndInv"
    vec4 fogColor;               // @@ id="fogColor"
};

#endif
