﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if PLATFORM != CAFE

#include "SandboxNnG3dEditor.h"

#include "g3ddemo_DemoUtility.h"
#include <nn/g3d/viewer/g3d_ViewerServer.h>

#if NN_G3D_VIEWER_CONFIG_IS_VIEWER_ENABLED

using namespace G3dSandbox;

namespace {
    SandboxNnG3dEditor* s_pInstance = NULL;
}

void SandboxNnG3dEditor::CreateInstance()
{
    if (!s_pInstance)
    {
        s_pInstance = new (nw::g3d::demo::AllocMem2(sizeof(SandboxNnG3dEditor))) SandboxNnG3dEditor();
    }
}

void SandboxNnG3dEditor::DeleteInstance()
{
    if(s_pInstance)
    {
        nw::g3d::demo::FreeMem2(s_pInstance);
        s_pInstance = NULL;
    }
}

SandboxNnG3dEditor* SandboxNnG3dEditor::GetInstance()
{
    return s_pInstance;
}

void SandboxNnG3dEditor::Poll()
{
    nn::g3d::viewer::ViewerServer::GetInstance().Poll();
}

void SandboxNnG3dEditor::ExecuteCommands()
{
    nn::g3d::viewer::ViewerServer::GetInstance().ExecuteCommands();
}

#endif
#endif
