﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# モデル、マテリアルに対してテスト用コメントを付加する
def Filter(target):

    materialNames = target.Argument.split(' ')

    if materialNames[0] == "":
        model = target.Document.SelectSingleNode("/nw4f_3dif/model")
        AddComment(target, model, target.FileNameWithoutExtension)
        target.Write()
        return

    for materialName in materialNames:
        material = target.Document.SelectSingleNode("/nw4f_3dif/model/material_array/material[@name='" + materialName + "']")
        if material:
            AddComment(target, material, materialName)
	target.Write()

def AddComment(target, element, name):

    oldComment = element.SelectSingleNode("comment")
    if oldComment:
        element.RemoveChild(oldComment)

    comment = target.Document.CreateElement("comment")
    comment.SetAttribute("color", "0 0.5 1")
    comment.SetAttribute("text", name + " のテスト用コメント。")
    element.AppendChild(comment)
