﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nnt/gtest/gtest.h>
#include <nnd/tmp451/tmp451.h>

namespace nnt { namespace tmp451 {

// Standby モードへの遷移を繰り返し呼んでも落ちないことのテスト
TEST(RepeatTest, SetStandby)
{
    using namespace nnd::tmp451;

    Initialize();

    nn::Result result = SetMeasurementMode(MeasurementMode::Standby);
    EXPECT_TRUE(result.IsSuccess());

    result = SetMeasurementMode(MeasurementMode::Standby);
    EXPECT_TRUE(result.IsSuccess());

    result = SetMeasurementMode(MeasurementMode::Standby);
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// Continuous モードへの遷移を繰り返し呼んでも落ちないことのテスト
TEST(RepeatTest, SetContinuous)
{
    using namespace nnd::tmp451;

    Initialize();

    nn::Result result = SetMeasurementMode(MeasurementMode::Continuous);
    EXPECT_TRUE(result.IsSuccess());

    result = SetMeasurementMode(MeasurementMode::Continuous);
    EXPECT_TRUE(result.IsSuccess());

    result = SetMeasurementMode(MeasurementMode::Continuous);
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// OneShot モードへの遷移を繰り返し呼んでも落ちないことのテスト
TEST(RepeatTest, SetOneShot)
{
    using namespace nnd::tmp451;

    Initialize();

    nn::Result result = SetMeasurementMode(MeasurementMode::OneShot);
    EXPECT_TRUE(result.IsSuccess());

    // 計測が行われていないことを確認
    while(GetMeasurementMode() != MeasurementMode::Standby)
    {
//        NN_LOG("Now being measured....\n");
//        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
    }
    result = SetMeasurementMode(MeasurementMode::OneShot);
    EXPECT_TRUE(result.IsSuccess());

    // 計測が行われていないことを確認
    while(GetMeasurementMode() != MeasurementMode::Standby)
    {
//        NN_LOG("Now being measured....\n");
//        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
    }
    result = SetMeasurementMode(MeasurementMode::OneShot);
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

}}
