﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include "testTime_TimeZoneTestUtil.h"

using namespace nn::time;

TEST(TimeZone, AsiaTokyo)
{
    const int64_t testSkipSeconds = nn::TimeSpan::FromHours(18).GetSeconds() + 1;

    NNT_ASSERT_RESULT_SUCCESS( Initialize() );
    RuleLoader rule("Asia/Tokyo");
    NNT_EXPECT_RESULT_SUCCESS(rule.Load());

    NNT_TIME_LOOPBACK_2(rule,
        TestCalendarType(1888, 1, 1, 0,  0,  0),
        TestCalendarType(1888, 1, 1, 0, 18, 58),
        TimeZoneType("LMT", false), TimeZoneType("JST", false), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1888, 1, 1, 0, 18, 59),
        TestCalendarType(1895, 12, 31, 23, 59, 59),
        TimeZoneType("JST", false), testSkipSeconds);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1896, 1, 1, 0,  0,  0),
        TestCalendarType(1937, 9, 30, 23, 59, 59),
        TimeZoneType("JST", false), testSkipSeconds);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1937, 10, 1, 0,  0,  0),
        TestCalendarType(1948,  5, 2, 1, 59, 59),
        TimeZoneType("JST", false), testSkipSeconds);

    NNT_TIME_LOOPBACK_0(rule,
        TestCalendarType(1948, 5, 2, 2, 0, 0),
        TestCalendarType(1948, 5, 2, 2, 0, 59), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1948, 5,  2, 3,  0,  0),
        TestCalendarType(1948, 9, 11, 0, 59, 59), // 01:00:00 から JST と JDT 2つになるのでその直前まで
        TimeZoneType("JDT", true), testSkipSeconds);

    NNT_TIME_LOOPBACK_2(rule,
        TestCalendarType(1948, 9, 11, 1,  0,  0),
        TestCalendarType(1948, 9, 11, 1, 59, 59),
        TimeZoneType("JDT", true),TimeZoneType("JST", false), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1948, 9, 11, 2, 0, 0),
        TestCalendarType(1949, 4,  3, 1, 59, 59),
        TimeZoneType("JST", false), testSkipSeconds);

    NNT_TIME_LOOPBACK_0(rule,
        TestCalendarType(1949, 4, 3, 2, 0, 0),
        TestCalendarType(1949, 4, 3, 2, 59, 59), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1949, 4,  3, 3,  0,  0),
        TestCalendarType(1949, 9, 10, 0, 59, 59),
        TimeZoneType("JDT", true), testSkipSeconds);

    NNT_TIME_LOOPBACK_2(rule,
        TestCalendarType(1949, 9, 10, 1,  0,  0),
        TestCalendarType(1949, 9, 10, 1, 59, 59),
        TimeZoneType("JDT", true),TimeZoneType("JST", false), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1949, 9, 10, 2,  0,  0),
        TestCalendarType(1950, 5,  7, 1, 59, 59),
        TimeZoneType("JST", false), testSkipSeconds);

    NNT_TIME_LOOPBACK_0(rule,
        TestCalendarType(1950, 5,  7, 2,  0,  0),
        TestCalendarType(1950, 5,  7, 2, 59, 59), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1950, 5,  7, 3,  0,  0),
        TestCalendarType(1950, 9,  9, 0, 59, 59),
        TimeZoneType("JDT", true), 60 * 60 * 2 + 1);

    NNT_TIME_LOOPBACK_2(rule,
        TestCalendarType(1950, 9,  9, 1,  0,  0),
        TestCalendarType(1950, 9,  9, 1, 59, 59),
        TimeZoneType("JDT", true),TimeZoneType("JST", false), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1950, 9, 9, 2,  0,  0),
        TestCalendarType(1951, 5, 6, 1, 59, 59),
        TimeZoneType("JST", false), testSkipSeconds);

    NNT_TIME_LOOPBACK_0(rule,
        TestCalendarType(1951, 5, 6, 2,  0,  0),
        TestCalendarType(1951, 5, 6, 2, 59, 59), 1);

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1951, 5, 6, 3, 0, 0),
        TestCalendarType(1951, 9, 8, 0, 59, 59),
        TimeZoneType("JDT", true), testSkipSeconds);

    NNT_TIME_LOOPBACK_2(rule,
        TestCalendarType(1951, 9, 8, 1, 0, 0),
        TestCalendarType(1951, 9, 8, 1, 59, 59),
        TimeZoneType("JDT", true),TimeZoneType("JST", false), 1);

     // 以下は時間かかるので skip 大きめ.
    const int64_t LargeTestSkipSeconds = nn::TimeSpan::FromDays(2).GetSeconds() + 1;

    NNT_TIME_LOOPBACK_1(rule,
        TestCalendarType(1951, 9, 8, 2, 0, 0),
        TestCalendarType(TestEndYear, 1, 1, 0, 0, 0),
        TimeZoneType("JST", false), LargeTestSkipSeconds);

    NNT_ASSERT_RESULT_SUCCESS( Finalize() );
}
