﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TicsCfg.h"
#include "Plug.h"

/*
    @brief 受け取ったデータを1度だけエコーして、CrossBar::Stop() を呼ぶプラグ。
*/
class EchoPlug : public ::tics::Plug
{
public:
    void OnSessionStarted (::tics::portability::stl::string type, ::tics::Endpoint* connectedEP);

    int OnReceiveComplete(::tics::Buffer* buffer, long offset, long len);

    int OnSendComplete(::tics::Buffer* buffer, long offset, long len);

    int OnDetach();

    int OnRemoteDetach();

private:
    // 送受信バッファ
    ::tics::Buffer* m_Buffer;
};
