﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*
    @brief
        HTC のテストプログラムにおいて、HotBridge の IP アドレスを管理します。
*/
class BridgeAddressManager
{
public:
    /*
        @brief
            HotBridge の IP アドレスを取得します。
        @param[out] pOutBuffer
            IP アドレスの文字列を格納する出力バッファの先頭を指すポインタ。
            文字列はヌル終端されます。
        @param[in] bufferLength
            pOutAddress が指すバッファの長さ。
    */
    void GetAddress(char* pOutBuffer, size_t bufferLength);

    /*
        @brief
            HotBridge の TCP ポート番号を文字列で取得します。
        @param[out] pOutBuffer
            ポート番号の文字列を格納する出力バッファの先頭を指すポインタ。
            文字列はヌル終端されます。
        @param[in] bufferLength
            pOutAddress が指すバッファの長さ。
    */
    void GetPort(char* pOutBuffer, size_t bufferLength);

private:
    // Key に対応する Value を取得する
    void GetValueByKey(char* pOutBuffer, size_t bufferLength, const char* pKey, const char* pDefaultValue);
};
