﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <cstring>

#include <nn/nn_SdkAssert.h>

#include <nnt/nntest.h>

#include "testHtc_BridgeAddressManager.h"

namespace {
    const char* DefaultBridgeAddress = "127.0.0.1";
    const char* DefaultBridgePort = "6003";
}

void BridgeAddressManager::GetAddress(char* pOutBuffer, size_t bufferLength)
{
    if(pOutBuffer == nullptr || bufferLength < 1)
    {
        return;
    }

    // 現在はデフォルト値しか利用できない
    strncpy(pOutBuffer, DefaultBridgeAddress, bufferLength);
    pOutBuffer[bufferLength - 1] = '\0';
    return;
}

void BridgeAddressManager::GetPort(char* pOutBuffer, size_t bufferLength)
{
    if(pOutBuffer == nullptr || bufferLength < 1)
    {
        return;
    }

    // 現在はデフォルト値しか利用できない
    strncpy(pOutBuffer, DefaultBridgePort, bufferLength);
    pOutBuffer[bufferLength - 1] = '\0';
    return;
}
