﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/tc/tc.h>
#include <nn/tc/tc_VirtualTemperature.h>

#include <nnt/nnt_Argument.h>

#include <nnt/gtest/gtest.h>

namespace nnt { namespace tc {

TEST(ThermalCoordinatorTest, TriggerThermalSleepSkin)
{
    nn::tc::Initialize();

    // Estimation-1(63.00(skin temperature threshold) - 0.50(estimation error)) =
    // = 82.50... (handheld soc)
    // = 82.90... (console soc)
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::tc::SetVirtualTemperature(nn::tc::Location_ThermalSensorExternal, 82910));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::tc::EnableVirtualTemperature(nn::tc::Location_ThermalSensorExternal));
    nn::tc::Finalize();
}

}} // namespace nnt::tc
