﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ts.h>

namespace nnt { namespace ts {

void SetTemperature(nn::ts::Location location, int temperature) NN_NOEXCEPT;
void SetTemperatureMilliC(nn::ts::Location location, int temperatureMilliC) NN_NOEXCEPT;
nn::ts::MeasurementMode GetMeasurementMode(nn::ts::Location location) NN_NOEXCEPT;
void SetErrorEnabled(nn::ts::Location location, bool enabled) NN_NOEXCEPT;

}} // namespace nnt::ts
