﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/pcv/pcv.h>
#include <nn/result/result_HandlingUtility.h>

namespace {

nn::pcv::TemperatureThreshold g_TemperatureThresholds[nn::pcv::MaxNumTemperatureThresholds];
int g_TemperatureThresholdsCount = 0;
nn::pcv::MilliC g_TemperatureMilliC = 0;

} // namespace

namespace nn { namespace pcv {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

Result GetTemperatureThresholds(TemperatureThreshold* pOutThresholds, int* pOutCount, int maxCount) NN_NOEXCEPT
{
    *pOutCount = std::min(maxCount, g_TemperatureThresholdsCount);

    for ( int index = 0; index < *pOutCount; index++, pOutThresholds++ )
    {
        *pOutThresholds = g_TemperatureThresholds[index];
    }

    NN_RESULT_SUCCESS;
}

Result SetTemperature(MilliC temperatureMilliC) NN_NOEXCEPT
{
    g_TemperatureMilliC = temperatureMilliC;

    NN_RESULT_SUCCESS;
}

}} // namespace nn::pcv

namespace nnt { namespace pcv {

void SetTemperatureThresholds(const nn::pcv::TemperatureThreshold* pThresholds, int count) NN_NOEXCEPT
{
    NN_ASSERT(count < nn::pcv::MaxNumTemperatureThresholds);

    for ( int index = 0; index < count; index++, pThresholds++ )
    {
        g_TemperatureThresholds[index] = *pThresholds;
    }

    g_TemperatureThresholdsCount = count;
}

nn::pcv::MilliC GetTemperature() NN_NOEXCEPT
{
    return g_TemperatureMilliC;
}

}} // namespace nnt::pcv

