﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/gpio/gpio.h>

TEST(ThermalTargetTool, SetVdd50AHigh)
{
    NN_LOG("[SetVdd50AHigh] set VDD50A High.\n");

    ::nn::gpio::Initialize();

    ::nn::gpio::GpioPadSession vdd50ASession;
    ::nn::gpio::OpenSession(&vdd50ASession, ::nn::gpio::GpioPadName_Vdd50AEn);
    ::nn::gpio::SetDirection(&vdd50ASession, ::nn::gpio::Direction_Output);
    ::nn::gpio::SetValue(&vdd50ASession, ::nn::gpio::GpioValue_High);
    ::nn::gpio::CloseSession(&vdd50ASession);

    ::nn::gpio::Finalize();
}
