﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "abuse_ui_RootView.h"

namespace nnt {
namespace abuse {


// main layout of the UI
RootView::RootView(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::View(glv::Rect(width, height))
    , m_Menu(MenuWidth, height)
    , m_Footer(width - RootPaddingX * 2, FooterHeight)
    , m_Content(width - RootPaddingX * 2, height - RootGap - RootPaddingY * 2 - FooterHeight)
    , m_Home(m_Content)
    , m_TaskList(m_Content)
    , m_Network(m_Content)
{
    m_Menu.pos(glv::Place::TR, 0, 0);
    m_Footer.pos(glv::Place::BL, RootPaddingX, glv::Rect::height() - RootPaddingY);
    m_Content.pos(glv::Place::TL, RootPaddingX, RootPaddingY);

    m_Menu.AttachContent(m_Content);

    *this << m_Footer << m_Content << m_Menu;
}

RootView::~RootView() NN_NOEXCEPT
{
}

} // ~abuse
} // ~nnt
