﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "abuse_ui_ContentView.h"

namespace nnt {
namespace abuse {

class PageView : public glv::View
{
    NN_DISALLOW_COPY( PageView );
    NN_DISALLOW_MOVE( PageView );

public:
    PageView(ContentView &content, const char *name) NN_NOEXCEPT
        : glv::View(glv::Rect(content.width(), content.height()))
        , m_Name(name)
    {
        content.add(this);

        enable(glv::Property::CropChildren);

        enable(glv::Property::Visible   |
                glv::Property::FocusToTop);
    }

    ~PageView() NN_NOEXCEPT
    {
        remove();
    }

    virtual const char *className() const { return "PageView"; };

    const char *name() NN_NOEXCEPT
    {
        return m_Name;
    }

private:
    const char *m_Name;
};

} // ~abuse
} // ~nnt
