﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>

#include "abuse_ui_Theme.h"
#include "abuse_ui_MenuView.h"

namespace nnt {
namespace abuse {


// layout of the menu
MenuView::MenuView(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::View(glv::Rect(width, height))
    , m_Placer(*this, glv::Direction::S, glv::Place::TL, 0, 20, 0)
{
    enable(glv::Property::CropChildren);

    disable(glv::Property::DrawBorder |
            glv::Property::Animate    |
            glv::Property::FocusToTop |
            glv::Property::Visible    );

    m_Style.color.back.set(0.1);
    style(&m_Style);

    g_Notifier.attach(Show, Event_ShowMenu, this);
    g_Notifier.attach(Hide, Event_HideMenu, this);
}

MenuView::~MenuView() NN_NOEXCEPT
{
    g_Notifier.detach(Hide, Event_HideMenu, this);
    g_Notifier.detach(Show, Event_ShowMenu, this);
}

void MenuView::onAnimate(double dsec)
{
    glv::space_t delta = m_Speed * dsec;

    bringToFront();

    if (m_Speed > 0) // show
    {
        if (left() + delta >= 0) // done
        {
            disable(glv::Property::Animate);
            pos(glv::Place::TL, 0, 0);
        }
        else
        {
            posAdd(delta, 0);
        }
    }
    else // hide
    {
        if (right() + delta <= 0) // done
        {
            disable(glv::Property::Animate | glv::Property::Visible);
            pos(glv::Place::TR, 0, 0);
        }
        else
        {
            posAdd(delta, 0);
        }
    }
}

void MenuView::AttachContent(ContentView& content)
{
    glv::View *pChild = content.child;

    while (pChild)
    {
        AddEntry(pChild);

        pChild = pChild->sibling;
    }

    MenuEntryView *pFirstEntry = static_cast<MenuEntryView*>(child);
    if (pFirstEntry != nullptr)
    {
        Hit(pFirstEntry);
    }
}

void MenuView::AddEntry(glv::View *pView)
{
    PageView& page = *static_cast<PageView*>(pView);
    m_Placer << new MenuEntryView(width(), MenuEntryHeight, page);
}

void MenuView::Hit(MenuEntryView *pEntry)
{
    MenuEntryView *pChild = static_cast<MenuEntryView*>(child);

    while (pChild)
    {
        pChild->Reset();
        pChild = static_cast<MenuEntryView*>(pChild->sibling);
    }

    pEntry->Hit();
    g_Notifier.notify(Event_HideMenu, nullptr);
}

void MenuView::Show(const glv::Notification& n)
{
    MenuView *self = n.receiver<MenuView>();

    self->enable(glv::Property::Animate | glv::Property::Visible);
    self->m_Speed = AnimationSpeed;
}

void MenuView::Hide(const glv::Notification& n)
{
    MenuView *self = n.receiver<MenuView>();

    self->enable(glv::Property::Animate | glv::Property::Visible);
    self->m_Speed = -AnimationSpeed;
}
} // ~abuse
} // ~nnt
