﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "abuse_ui_Theme.h"
#include "abuse_ui_MenuEntryView.h"
#include "abuse_ui_MenuView.h"

namespace nnt {
namespace abuse {


// a single item in the menu
MenuEntryView::MenuEntryView(const unsigned width, const unsigned height,
                             PageView& page) NN_NOEXCEPT
    : glv::View(glv::Rect(width, height))
    , m_Page(page)
{
    enable(glv::Property::HitTest);
    disable(glv::Property::DrawBorder);

    cloneStyle().colors().back.set(MenuInactiveBack);

    m_Title.cloneStyle();
    m_Title.size(MenuFontSize).stroke(2);
    m_Title.setValue(page.name());
    m_Title.pos(glv::Place::CL, 10, height / 2);

    *this << m_Title;
}

MenuEntryView::~MenuEntryView() NN_NOEXCEPT
{
}

bool MenuEntryView::onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT
{
    MenuView *pMenu = static_cast<MenuView*>(parent);

    if (e == glv::Event::MouseDown)
    {
        if (pMenu)
        {
            pMenu->Hit(this);
        }
        return false;
    }
    else
    {
        return true;
    }
}

void MenuEntryView::Hit()
{
    colors().back.set(MenuActiveBack);
    m_Title.colors().text.set(MenuActiveText);

    m_Page.enable(glv::Property::Visible);
}

void MenuEntryView::Reset()
{
    colors().back.set(MenuInactiveBack);
    m_Title.colors().text.set(MenuInactiveText);

    m_Page.disable(glv::Property::Visible);
}

} // ~abuse
} // ~nnt
