﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <Tasks/HelloTask.h>
#include <Platform.h>
#include <new>


namespace nnt
{
    namespace abuse
    {
        HelloTask::HelloTask(const String& typeName, const String& instanceName)
            : BaseTask(typeName, instanceName)
        {
        }

        HelloTask::~HelloTask()
        {
        }

        InitStatus HelloTask::Initialize(const String& params)
        {
            LogInfo("%s\n", params.c_str());
            LogInfo("Hello Initialize\n");
            m_yieldCounter = 0;

            hang = false;
            if(params=="Hang")
                hang = true;

            return INIT_OK;
        }

        StartStatus HelloTask::Start()
        {
            LogInfo("Hello Start\n");

            m_runCounter = 0;
            return START_OK;
        }

        RunStatus HelloTask::Run()
        {
            LogVerbose("Hello run\n");
            if(m_runCounter < 0)
            {
                LogError("Hello Error: m_runCount should never be negative\n");
                return RUN_ERROR;
            }

            while(hang && CanRun());

            if(m_runCounter >= 1000)
            {

                ++m_yieldCounter;

                if(m_yieldCounter > 1000)
                {
                    LogInfo("Hello run Kill\n");
                    //return RUN_KILL;
                }

                //LogInfo("Hello run yield\n");
                return RUN_OK;
            }
            ++m_runCounter;

            return RUN_OK;
        }

        StopStatus HelloTask::Stop()
        {
            if(m_runCounter >= 100001)
            {
                LogInfo("Hello Error: m_counter > 11 - it should have stopped at 10\n");
                return STOP_ERROR;
            }
            m_runCounter = 0;
            LogInfo("Hello Stop\n");
            return STOP_OK;
        }

        ShutdownStatus HelloTask::Shutdown()
        {
            LogInfo("Hello Shutdown\n");

            return SHUTDOWN_OK;
        }
    }
}
