﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <algorithm>
#include <Tasks/FsStressTask.h>
#include <nn/nn_Log.h>
namespace nnt { namespace abuse {


    FsStressTask::FsStressTask(const String& typeName, const String& instanceName) : BaseTask(typeName, instanceName),
            m_readFilenames(),
            m_writeFilenames(),
            m_readFiles(),
            m_writeFiles(),
            m_readDir(""),
            m_writeDir("")
    {}

    FsStressTask::~FsStressTask()
    {}

    InitStatus FsStressTask::Initialize(const String& params)
    {
        (void)params;
        m_readDir = "FsStressFiles\\Read";
        m_writeDir = "FsStressFiles\\Write";

        Platform::GetFilesInDir(m_readFilenames, m_readDir.c_str(), true);
        Platform::GetFilesInDir(m_writeFilenames, m_writeDir.c_str(), true);
        LogInfo("FsStress Init OK\n");
        return INIT_OK;
    }

    StartStatus FsStressTask::Start()
    {
        LogInfo("Start time: %llu\n", Platform::GetSystemRunningTimeMilli());
        OpenOptions readOptions;
        readOptions.read = true;
        if(! sOpenFiles(m_readFilenames, m_readFiles, readOptions) )
        {
            LogInfo("FsStress Resource Denied\n");
            return START_RESOURCE_DENIED;
        }

        OpenOptions writeOptions;
        writeOptions.write = true;
        if(! sOpenFiles(m_writeFilenames, m_writeFiles, writeOptions))
        {
            LogInfo("FsStress Resource Denied\n");
            return START_RESOURCE_DENIED;
        }
        LogInfo("End time: %llu\n", Platform::GetSystemRunningTimeMilli());
        LogInfo("FsStress Start OK\n");
        return START_OK;
    }

    RunStatus FsStressTask::Run()
    {
        const int BUFFER_SIZE = 1024;
        char buffer[BUFFER_SIZE + 1];
        for(unsigned i = 0; i < m_readFiles.size(); ++i)
        {
            #undef min
            int size = (int)std::min(Platform::GetFileSize(m_readFiles[i]), (int64_t)BUFFER_SIZE);
            Platform::FileRead(m_readFiles[i], 0, buffer, size);
            buffer[size] = 0;
            LogInfo("Reading from %s: %s\n", m_readFilenames[i].c_str(), buffer);
        }

        memset(buffer, 'A', BUFFER_SIZE);
        for(unsigned i = 0; i < m_writeFiles.size(); ++i)
        {
            Platform::FileWrite(m_writeFiles[i], buffer, BUFFER_SIZE, false);
            buffer[BUFFER_SIZE]= 0;
            LogInfo("Writing from %s: %s\n", m_writeFilenames[i].c_str(), buffer);
        }
        LogInfo("Run OK\n");
        return RUN_OK;
    }

    StopStatus FsStressTask::Stop()
    {
        for(unsigned i = 0; i < m_readFiles.size(); ++i)
            Platform::FileClose(m_readFiles[i]);
        m_readFiles.clear();
        for(unsigned i = 0; i < m_writeFiles.size(); ++i)
            Platform::FileClose(m_writeFiles[i]);
        m_writeFiles.clear();
        LogInfo("Stop OK\n");
        return STOP_OK;
    }

    ShutdownStatus FsStressTask::Shutdown()
    {
        LogInfo("Shutdown OK\n");
        return SHUTDOWN_OK;
    }

    const char* FsStressTask::GetParamOptions()
    {
        return "";
    }

}    }
