﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <algorithm>
#define _POSIX_
#include <cstdio>
int _isatty(int fd);
// int _fileno(FILE *stream);

#include <Abuse.h>
#include <Tasks/CpuMatrixTask.h>
#include <Tasks/CpuThrashTask.h>
//#include <Tasks/CurlStressTask.h>
#include <Tasks/OsEventTask.h>
#include <Tasks/FsStressTask.h>
#include <Tasks/LogReaderTask.h>
#include <Tasks/HelloTask.h>
#include <Tasks/NetworkStressTask.h>
#include <Tasks/NetworkTransferTask.h>
#include <Tasks/OsBarrierTask.h>
#include <Tasks/OsConditionVariableTask.h>
#include <Tasks/OsMemoryTask.h>
#include <Tasks/OsMutexTask.h>
#include <Tasks/OsSemaphoreTask.h>
#include <Tasks/OsThreadTask.h>
#include <Tasks/OsTimerTask.h>
#include <Tasks/OsTlsTask.h>
#include <Tasks/UnitTestTask.h>
#include <TaskList.h>

namespace nnt
{
    namespace abuse
    {

        void RegisterTasks()
        {
            //Register all tasks here so abuse knows how to map task names to functions
            Abuse::RegisterTask("HelloTask", BaseTask::CreateTask<HelloTask>);
            Abuse::RegisterTask("CpuMatrixTask", BaseTask::CreateTask<CpuMatrixTask>);
            Abuse::RegisterTask("NetworkStressTask", BaseTask::CreateTask<NetworkStressTask>);
            Abuse::RegisterTask("NetworkTransferTask", BaseTask::CreateTask<NetworkTransferTask>);
            Abuse::RegisterTask("CpuThrashTask", BaseTask::CreateTask<CpuThrashTask>);
            Abuse::RegisterTask("FsStressTask", BaseTask::CreateTask<FsStressTask>);
            Abuse::RegisterTask("OsMutexTask", BaseTask::CreateTask<OsMutexTask>);
            Abuse::RegisterTask("OsBarrierTask", BaseTask::CreateTask<OsBarrierTask>);
            Abuse::RegisterTask("OsMemoryTask", BaseTask::CreateTask<OsMemoryTask>);
            Abuse::RegisterTask("OsTlsTask", BaseTask::CreateTask<OsTlsTask>);
            Abuse::RegisterTask("OsSemaphoreTask", BaseTask::CreateTask<OsSemaphoreTask>);
            Abuse::RegisterTask("OsTimerTask", BaseTask::CreateTask<OsTimerTask>);
            Abuse::RegisterTask("OsEventTask", BaseTask::CreateTask<OsEventTask>);
            Abuse::RegisterTask("OsThreadTask", BaseTask::CreateTask<OsThreadTask>);
            Abuse::RegisterTask("OsConditionVariableTask", BaseTask::CreateTask<OsConditionVariableTask>);
            Abuse::RegisterTask("UnitTestTask", BaseTask::CreateTask<UnitTestTask>);
            Abuse::RegisterTask("LogReaderTask", BaseTask::CreateTask<LogReaderTask>);
          //  Abuse::RegisterTask("CurlStressTask", BaseTask::CreateTask<CurlStressTask>);
        }
    }
}
