﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <Commands/CommandWait.h>

namespace nnt
{
    namespace abuse
    {
        ParseResult CommandWait::ParseArgs(const ArgVector& args, CommandVector& commandList )
        {
            NN_UNUSED(commandList);
            if(args.size() == 0)
            {
                waitSeconds = 0xFFFFFFFF;
                return ParseResult::PARSE_SUCCESS;
            }
            else if(args.size() == 1)
            {
                bool parsed = ParseUnsigned(&waitSeconds, args.front().argValue);

                if(!parsed)
                    return ParseResult::PARSE_INVALID_ARG;
                return ParseResult::PARSE_SUCCESS;
            }
            endTimeSet = false;
            return ParseResult::PARSE_INVALID_ARG;
        }

        bool CommandWait::Execute(unsigned& nextCommand)
        {
            if(waitSeconds == 0xFFFFFFFF)
                return true;

            nn::os::Tick now = nn::os::GetSystemTick();

            if(!endTimeSet)
            {
                endTime = now + nn::os::ConvertToTick(nn::TimeSpan::FromSeconds(waitSeconds));
                endTimeSet = true;
            }

            if(now > endTime)
            {
                ++nextCommand;
                endTimeSet = false;
            }

            return true;
        }
    }
}
