﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <Commands/BaseCommand.h>
#include <ScriptCommands.h>
namespace nnt
{
    namespace abuse
    {
        int BaseCommand::GetFileLine()
        {
            return m_fileLine;
        }
        const char* BaseCommand::GetCommandName()
        {
            if(m_commandIndex <= GetNumRegisteredCommands())
            {
                return validCommands[m_commandIndex].name;
            }
            return "BaseTask: Invalid CommandIndex";
        }

        CommandType BaseCommand::GetCommandType()
        {
            if(m_commandIndex <= GetNumRegisteredCommands())
            {
                return validCommands[m_commandIndex].command;
            }
            return CommandType::COMMAND_UNKNOWN;
        }
    }
}
