﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <list>
// #include <nnt/nntest.h>
#include "BaseTask.h"

namespace nnt
{
    namespace abuse
    {
        static const int MAX_PATH_LENGTH  = 256;
        static const int STACK_SIZE = 4096;
        static const int MAX_NUM_THREADS = 10;

        struct UnitTestThreadArg {
            char fileName[MAX_PATH_LENGTH];
        };

        struct UnitTestThreadInfo
        {
            nn::os::ThreadType thread;
            void* stack;
            UnitTestThreadArg arg;
        };

        class UnitTestTask : public BaseTask
        {
        public:
            UnitTestTask(const String& typeName, const String& instanceName);
            virtual ~UnitTestTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();

            // static function for launching the Google unit test program
            static void ThreadFunc(void* threadArg);

        private:
            std::list<UnitTestThreadInfo, PlatformAllocator<UnitTestThreadInfo>> m_listThreadInfo;
        };


    }
}
