﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <Tasks/BaseTask.h>
namespace nnt
{
    namespace abuse
    {
        class OsMutexTask;
        struct MutexThreadArg
        {
            OsMutexTask* task;
            int group;
        };

        class OsMutexTask : public BaseTask
        {
        public:
            OsMutexTask(const String& typeName, const String& instanceName);
            virtual ~OsMutexTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();

            virtual const char* GetParamOptions();
        private:
            static void workerFunc(void* arg);
            static void lockedAdd(MutexThreadArg* arg, bool useLock, int callDepth);

            MutexThreadArg*     m_threadArgs;
            nn::os::ThreadType* m_threads;
            void**              m_stacks;
            nn::os::MutexType*  m_mutex;
            int*                m_groupCounter;
            int                 m_maxThreads;
            int                 m_maxGroups;
            int                 m_numGroups;
            int                 m_numThreads;
            int                 m_numActualThreads;
            int                 m_priority;
            int                 m_threadIterations;
            int                 m_lockLevel;
            int                 m_recursiveCount;
            bool                m_useTryLock;
            bool                m_useLock;
        };
    }
}
