﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <vector>
#include <Platform.h>
#include <ScriptCommands.h>
#include <Commands/CommandCommon.h>
#include <AbuseString.h>
namespace nnt
{
    namespace abuse
    {
        class BaseCommand;

        struct LoadedScript
        {
            String scriptName;
            String scriptPath;
        };

        class FileUtility
        {
        public:
            static void Initialize(const char* scriptDirectoryPath);
            static void Shutdown();

            static bool LoadScript(const String& scriptName, CommandVector& commands);
            static BaseCommand* ParseCommand(const String& command);
            static bool ParseArgs(char* line, int lineLength, ArgVector& argList);
            static int  TrimBuffer(char* line, int lineLength, bool removeNewLines=false,bool removeQuotes=false);
            static int  IsValidCommand(const char* line);

            static bool ParamsToArgs(const String& params, ArgVector& args);
            /*
                Attempt to parse arg as the given type.
                If arg cannot be parsed or is outside [min, max], returns false and out is unchanged
                otherwise returns true and out is set to the parsed value.
            */
            static bool TryParseInt(const ScriptArg& arg, int min, int max, int* out );
            static bool TryParseUnsigned(const ScriptArg& arg, unsigned min, unsigned max, unsigned* out );
            static bool TryParseBool(const ScriptArg& arg, bool* out);
        private:
            static bool parseBuffer(char* buffer, int bufferSize, int& lineNum, CommandVector& commands);
            static ParseResult parseLine(char* line, int lineLength, int lineNum, CommandVector& commands);


        };
    }
}
