﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ro/detail/ro_RoModule.h>
#include <nn/svc/svc_Base.h>

/* Copy-pasted from rtld_Setup */
extern "C" void nntSvcFwkLdrRelocate(uintptr_t base, const nn::ro::detail::Elf::Dyn* pDynamicSection)
{
    size_t relEnt = 0;
    size_t relaEnt = 0;
    size_t relCount = 0;
    size_t relaCount = 0;
    uintptr_t dynRel = 0;
    uintptr_t dynRela = 0;

    for (const nn::ro::detail::Elf::Dyn* pDyn = pDynamicSection; pDyn->GetTag() != nn::ro::detail::Elf::DT_NULL; pDyn++)
    {
        if (pDyn->GetTag() == nn::ro::detail::Elf::DT_REL)
        {
            dynRel = base + pDyn->GetPtr();
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELA)
        {
            dynRela = base + pDyn->GetPtr();
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELENT)
        {
            relEnt = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELAENT)
        {
            relaEnt = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELCOUNT)
        {
            relCount = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELACOUNT)
        {
            relaCount = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELENT)
        {
            while (pDyn->GetVal() != sizeof(nn::ro::detail::Elf::Rel)) {}
        }
        else if (pDyn->GetTag() == nn::ro::detail::Elf::DT_RELAENT)
        {
            while (pDyn->GetVal() != sizeof(nn::ro::detail::Elf::Rela)) {}
        }
    }

    for (size_t i = 0; i < relCount; i++)
    {
        nn::ro::detail::Elf::Rel& rel = *reinterpret_cast<nn::ro::detail::Elf::Rel*>(dynRel + relEnt * i);
        while (rel.GetType() != nn::ro::detail::Elf::R_RELATIVE) {}
        nn::ro::detail::Elf::Addr* pTarget = reinterpret_cast<nn::ro::detail::Elf::Addr*>(base + rel.GetOffset());
        *pTarget += base;
    }

    for (size_t i = 0; i < relaCount; i++)
    {
        nn::ro::detail::Elf::Rela& rela = *reinterpret_cast<nn::ro::detail::Elf::Rela*>(dynRela + relaEnt * i);
        while (rela.GetType() != nn::ro::detail::Elf::R_RELATIVE) {}
        nn::ro::detail::Elf::Addr* pTarget = reinterpret_cast<nn::ro::detail::Elf::Addr*>(base + rela.GetOffset());
        *pTarget = base + rela.GetAddend();
    }
}

extern "C" void nntSvcFwkLdrExit()
{
    nn::svc::ExitProcess();
}

extern "C" void nntSvcFwkLdrClearBss(uint8_t* bss, size_t bssSize)
{
    while (bssSize--)
        *(bss++) = 0;
}

extern "C"
{
    extern void (*__init_array_start []) ();
    extern void (*__init_array_end []) ();
}

extern "C" void nntSvcFwkLdrCallConstructors()
{
    for (void (**f)() = __init_array_start; f < __init_array_end; ++f)
    {
        (*f)();
    }
}

extern "C" void __cxa_pure_virtual()
{
    nn::svc::OutputDebugString(
        "pure virtual function call\n",
        27);
    nn::svc::Break(nn::svc::BreakReason_Panic, 0, 0);
}
