﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef>

namespace nnt { namespace svc { namespace fwk {

enum Color
{
    Color_Normal,
    Color_Green,
    Color_Red
};

void RunAllTests();
void Printf(const char* fmt, ...);
int SNPrintf(char* buffer, size_t bufferSize, const char* fmt, ...);
void TaggedPrintf(Color tagColor, const char* tag, const char* fmt, ...);
void DumpTrackers();

} } }

#include "fwk_Api.impl.h"
#include <nn/svc/svc_Base.h>

#define NNT_SVC_FWK_TEST(testCaseName, testName) \
    static void TestFunction_ ## testCaseName ## _ ## testName (); \
    static ::nnt::svc::fwk::TestAdder s_TestAdder_ ## testCaseName ## _ ## testName (#testCaseName, #testName, TestFunction_ ## testCaseName ## _ ## testName); \
    static void TestFunction_ ## testCaseName ## _ ## testName ()

#define NNT_SVC_FWK_CONCAT2(a, b) a##b
#define NNT_SVC_FWK_CONCAT(a, b) NNT_SVC_FWK_CONCAT2(a, b)
#define NNT_SVC_FWK_TEST_CASE_DEPENDS_ON(testCaseName, requiredTestCaseName) \
    static ::nnt::svc::fwk::TestCaseDependencyAdder NNT_SVC_FWK_CONCAT(s_TestDependencyAdder, __LINE__) (#testCaseName, #requiredTestCaseName)


#define NNT_SVC_FWK_SUBTEST(subTestName) \
    ::nnt::svc::fwk::ScopedSubTest subTest_ ## subTestName (#subTestName);

#define NNT_SVC_FWK_SUBTEST_FMT(format, ...) \
    char NNT_SVC_FWK_CONCAT(subTestName, __LINE__)[64]; \
    ::nnt::svc::fwk::SNPrintf(NNT_SVC_FWK_CONCAT(subTestName, __LINE__), 64, format, __VA_ARGS__); \
    ::nnt::svc::fwk::ScopedSubTest NNT_SVC_FWK_CONCAT(subTest_, __LINE__) (NNT_SVC_FWK_CONCAT(subTestName, __LINE__));

#define NNT_SVC_FWK_TRACK_VARIABLE(variable) \
    ::nnt::svc::fwk::ScopedVariableTracker<decltype(variable)> NNT_SVC_FWK_CONCAT(VariableTracker_, __LINE__) (#variable, variable)

#define NNT_SVC_FWK_TRACK_LAMBDA(lambdaName, lambda) \
    auto lambdaTracker_ ## lambdaName = ::nnt::svc::fwk::MakeScopedLambdaTracker(#lambdaName, lambda)

#define NNT_SVC_FWK_ABORT() \
    { \
        ::nnt::svc::fwk::DumpTrackers(); \
        ::nn::svc::Break(::nn::svc::BreakReason_Panic, 0, 0); \
    }

#define NNT_SVC_FWK_ABORT_UNLESS(condition) \
    do \
    { \
        bool NNT_SVC_FWK_CONCAT(abort_unless_condition, __LINE__) = (condition); \
        if (! NNT_SVC_FWK_CONCAT(abort_unless_condition, __LINE__)) \
        { \
            ::nnt::svc::fwk::TaggedPrintf(nnt::svc::fwk::Color_Red, "   FAIL   ", "Abort at %s:%d\n%s is false.\n", __FILE__, __LINE__, #condition); \
            NNT_SVC_FWK_ABORT(); \
        } \
    } while(false)

#define NNT_SVC_FWK_ASSERT(condition) NNT_SVC_FWK_ABORT_UNLESS(condition)

#define NNT_SVC_FWK_ASSERT_SUCCESS(result) \
    do \
    { \
        nn::Result NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__) = (result); \
        if (! NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).IsSuccess()) \
        { \
            ::nnt::svc::fwk::TaggedPrintf( \
                nnt::svc::fwk::Color_Red, \
                "   FAIL   ", \
                "Got failure at %s:%d\n%s returned result %d/%d.\n", \
                __FILE__, __LINE__, #result, \
                NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).GetModule(), \
                NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).GetDescription()); \
            NNT_SVC_FWK_ABORT(); \
        } \
    } while(false)

#define NNT_SVC_FWK_ASSERT_RESULT(ExpectedResult, actualResult) \
    do \
    { \
        nn::Result NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__) = (actualResult); \
        if (! ExpectedResult::Includes(NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__))) \
        { \
            ::nnt::svc::fwk::TaggedPrintf( \
                nnt::svc::fwk::Color_Red, \
                "   FAIL   ", \
                "Unexpected result at %s:%d\n%s: expected %s (%d/%d), got %d/%d.\n", \
                __FILE__, __LINE__, #actualResult, \
                #ExpectedResult, ExpectedResult().GetModule(), ExpectedResult().GetDescription(), \
                NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).GetModule(), \
                NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).GetDescription()); \
            NNT_SVC_FWK_ABORT(); \
        } \
    } while(false)

#define NNT_SVC_FWK_ASSERT_RESULTS(actualResult, ...) \
    do \
    { \
        nn::Result NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__) = (actualResult); \
        if (! ::nnt::svc::fwk::ResultIsOneOf<__VA_ARGS__>(NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__))) \
        { \
            ::nnt::svc::fwk::TaggedPrintf( \
                nnt::svc::fwk::Color_Red, \
                "   FAIL   ", \
                "Unexpected result at %s:%d\n%s: got %d/%d.\nExpected one of: ", \
                __FILE__, __LINE__, #actualResult, \
                NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).GetModule(), \
                NNT_SVC_FWK_CONCAT(abort_unless_result, __LINE__).GetDescription()); \
            ::nnt::svc::fwk::PrintResults<__VA_ARGS__>(); \
            ::nnt::svc::fwk::Printf("\n"); \
            NNT_SVC_FWK_ABORT(); \
        } \
    } while(false)

#define NNT_SVC_FWK_ASSERT_EQUAL(expected_, actual_) \
    do \
    { \
        unsigned long long NNT_SVC_FWK_CONCAT(expected, __LINE__) = \
            static_cast<unsigned long long> (expected_); \
        unsigned long long NNT_SVC_FWK_CONCAT(actual, __LINE__)   = \
            static_cast<unsigned long long> (actual_); \
        if (NNT_SVC_FWK_CONCAT(expected, __LINE__) != NNT_SVC_FWK_CONCAT(actual, __LINE__)) \
        { \
            ::nnt::svc::fwk::TaggedPrintf( \
                nnt::svc::fwk::Color_Red, \
                "   FAIL   ", \
                "Got failure at %s:%d\nExpected: 0x%llx (%s)\nActual  : 0x%llx (%s))\n", \
                __FILE__, __LINE__, \
                NNT_SVC_FWK_CONCAT(expected, __LINE__), #expected_, \
                NNT_SVC_FWK_CONCAT(actual, __LINE__), #actual_); \
            NNT_SVC_FWK_ABORT(); \
        } \
    } while(false)

#define NNT_SVC_FWK_ASSERT_GREATER_EQUAL(x, y) NNT_SVC_FWK_ASSERT((x) >= (y))
