﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/svc/svc_Tcb.h>
#include <nn/util/util_BitPack.h>
#include <nn/svc/svc_Version.h>

namespace {

const int DefaultCapabilityFlagNum = 4;
const nn::Bit32 PaddingFlag = 0xffffffff;

}

typedef nn::util::BitPack32::Field<0,                          4, nn::Bit32>  No3Signature;
typedef nn::util::BitPack32::Field<No3Signature::Next,         6, uint8_t>     No3LowestPriority;
typedef nn::util::BitPack32::Field<No3LowestPriority::Next,    6, uint8_t>     No3HighestPriority;
typedef nn::util::BitPack32::Field<No3HighestPriority::Next,   8, uint8_t>     No3MinCoreNumber;
typedef nn::util::BitPack32::Field<No3MinCoreNumber::Next,     8, uint8_t>     No3MaxCoreNumber;
typedef nn::util::BitPack32::Field<No3Signature::Next,        28, nn::Bit32>  No3DataField;

typedef nn::util::BitPack32::Field<0,                          5, nn::Bit32>  No4Signature;
typedef nn::util::BitPack32::Field<No4Signature::Next,        24, nn::Bit32>  No4SvcFlags;
typedef nn::util::BitPack32::Field<No4SvcFlags::Next,          3, uint8_t>     No4Index;
typedef nn::util::BitPack32::Field<No4Signature::Next,        27, nn::Bit32>  No4DataField;

typedef nn::util::BitPack32::Field<0,                          7, nn::Bit32>  No6Signature;
typedef nn::util::BitPack32::Field<No6Signature::Next,        24, uint32_t>   No6Address;
typedef nn::util::BitPack32::Field<No6Address::Next,           1, bool>       No6Flag;
typedef nn::util::BitPack32::Field<No6Signature::Next,        25, nn::Bit32>  No6DataField;

typedef nn::util::BitPack32::Field<0,                          8, nn::Bit32>  No7Signature;
typedef nn::util::BitPack32::Field<No7Signature::Next,        24, uint32_t>   No7Address;
typedef nn::util::BitPack32::Field<No7Signature::Next,        24, nn::Bit32>  No7DataField;

typedef nn::util::BitPack32::Field<0,                         12, nn::Bit32>  No11Signature;
typedef nn::util::BitPack32::Field<No11Signature::Next,       10, uint16_t>    No11Interrupt1;
typedef nn::util::BitPack32::Field<No11Interrupt1::Next,      10, uint16_t>    No11Interrupt2;
typedef nn::util::BitPack32::Field<No11Signature::Next,       20, nn::Bit32>  No11DataField;

typedef nn::util::BitPack32::Field<0,                         14, nn::Bit32>  No13Signature;
typedef nn::util::BitPack32::Field<No13Signature::Next,        3, nn::Bit32>  No13ProgramType;
typedef nn::util::BitPack32::Field<No13ProgramType::Next,     15, nn::Bit32>  No13Reserved;
typedef nn::util::BitPack32::Field<No13Signature::Next,       18, nn::Bit32>  No13DataField;

typedef nn::util::BitPack32::Field<0,                         15, nn::Bit32>  No14Signature;
typedef nn::util::BitPack32::Field<No14Signature::Next,        4, uint8_t>     No14MinorVersion;
typedef nn::util::BitPack32::Field<No14MinorVersion::Next,    13, uint16_t>    No14MajorVersion;
typedef nn::util::BitPack32::Field<No14Signature::Next,       17, nn::Bit32>  No14DataField;

typedef nn::util::BitPack32::Field<0,                         16, nn::Bit32>  No15Signature;
typedef nn::util::BitPack32::Field<No15Signature::Next,       10, uint16_t>    No15HandleTableSize;
typedef nn::util::BitPack32::Field<No15HandleTableSize::Next,  6, nn::Bit8>   No15Reserved;
typedef nn::util::BitPack32::Field<No15Signature::Next,       16, nn::Bit16>  No15DataField;

typedef nn::util::BitPack32::Field<0,                         17, nn::Bit32>  No16Signature;
typedef nn::util::BitPack32::Field<No16Signature::Next,        1, bool>       No16EnableDebug;
typedef nn::util::BitPack32::Field<No16EnableDebug::Next,      1, bool>       No16ForceDebug;
typedef nn::util::BitPack32::Field<No16ForceDebug::Next,      13, nn::Bit16>  No16Reserved;
typedef nn::util::BitPack32::Field<No16Signature::Next,       15, nn::Bit16>  No16DataField;

void SetDefaultParam(nn::svc::CreateProcessParameter* param);

void SetDefaultCapability(nn::Bit32* pOut, int32_t maxFlagNum);

nn::Bit32 CapabilitySignature(int32_t entryNo);

void MakeNo3Flag(nn::Bit32* pOut, uint8_t lowestPriority, uint8_t highestPriority,
                 uint16_t minCore, uint16_t maxCore);

void MakeNo4Flag(nn::Bit32* pOut, int32_t syscallNo);

void MakeNo4Flag(nn::Bit32* pOut, int32_t* pFlagNum,
                 int32_t maxFlagNum, int32_t* syscallNo, int32_t syscallNum);

void MakeNo6Flag(nn::Bit32* pOut, int32_t maxFlagNum, uint64_t phyAddr, size_t mapSize,
                 bool isWrite, bool isIo);

void MakeNo7Flag(nn::Bit32* pOut, uint64_t phyAddr);

void MakeNo11Flag(nn::Bit32* pOut, int32_t* pFlagNum,
                 int32_t maxFlagNum, const uint16_t* names, int32_t nameNum);

void MakeNo13Flag(nn::Bit32* pOut, uint32_t programType, uint32_t reserved);

void MakeNo14Flag(nn::Bit32* pOut, uint16_t major, uint8_t minor);

void MakeNo15Flag(nn::Bit32* pOut, uint16_t data);

void MakeNo16Flag(nn::Bit32* pOut, uint16_t data);

void WaitProcess(nn::svc::Handle handle);

uint64_t GetIoAddress(uint64_t size);

