﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Base.h>

enum DataType
{
    DataType_ProcessId,
    DataType_CopyHandle,
    DataType_MoveHandle,
    DataType_PointerWithIpc,
    DataType_PointerWithOne,
    DataType_PointerWithMulti,
    DataType_MapSend,
    DataType_MapRecv,
    DataType_MapExch,
    DataType_Raw,
    DataType_All,
};

const DataType DataTypeArray[] = {
    DataType_ProcessId,
    DataType_CopyHandle,
    DataType_MoveHandle,
    DataType_PointerWithIpc,
    DataType_PointerWithOne,
    DataType_PointerWithMulti,
    DataType_MapSend,
    DataType_MapRecv,
    DataType_MapExch,
    DataType_Raw,
    DataType_All,
};
const int DataTypeArraySize = static_cast<int>(sizeof(DataTypeArray) / sizeof(DataTypeArray[0]));

struct TestIpcMapData
{
    uintptr_t sendAddr;
    uintptr_t receiveAddr;
    uintptr_t exchangeAddr;
};

void MakeClientIpcAllData(
        nn::svc::Handle* pCopyHandle, nn::svc::Handle* pMoveHandle, nn::Bit32* pMsgBuffer);

void MakeClientProcessIdData(nn::Bit32* pMsgBuffer);

void MakeClientCopyHandleData(nn::svc::Handle* pOut, nn::Bit32* pMsgBuffer);

void MakeClientMoveHandleData(nn::svc::Handle* pOut, nn::Bit32* pMsgBuffer);

void MakeClientPointerDataWithIpcBuffer(nn::Bit32* pMsgBuffer);

void MakeClientPointerDataWithOneUserBufferData(nn::Bit32* pMsgBuffer);

void MakeClientPointerDataWithMultiUserBufferData(nn::Bit32* pMsgBuffer);

void MakeClientMapSendData(nn::Bit32* pMsgBuffer);

void MakeClientMapRecvData(nn::Bit32* pMsgBuffer);

void MakeClientMapExchData(nn::Bit32* pMsgBuffer);

void MakeClientRawData(nn::Bit32* pMsgBuffer);

void ServerCheckProcessId(nn::Bit32* pMsgBuffer);

void ServerCheckCopyHandle(nn::Bit32* pMsgBuffer);

void ServerCheckPointerWithIpc(nn::Bit32* pMsgBuffer, size_t msgSize);

void ServerCheckPointerWithOne(nn::Bit32* pMsgBuffer);

void ServerCheckPointerWithMulti(nn::Bit32* pMsgBuffer);

void ServerCheckMapSendData(uintptr_t* pOut, nn::Bit32* pMsgBuffer);

void ServerCheckMapRecvData(uintptr_t* pOut, nn::Bit32* pMsgBuffer);

void ServerCheckMapExchData(uintptr_t* pOut, nn::Bit32* pMsgBuffer);

void ServerCheckRawData(nn::Bit32* pMsgBuffer);

void ServerCheckAllData(
        uintptr_t* sendMapAddr, uintptr_t* receiveMapAddr, uintptr_t* exchangeMapAddr,
        nn::Bit32* pMsgBuffer);

void ServerCheckIpcData(
        TestIpcMapData* pOutMapData, nn::Bit32* pMsgBuffer, size_t msgSize, DataType dataType);

void PrepairServerIpc(nn::Bit32* pMsgBuffer, DataType dataType);

void MakeClientData(nn::svc::Handle* pOutCopyHandle, nn::Bit32* pMsgBuffer, DataType dataType);

void GetClientMapArea(uintptr_t* pOutAddress, size_t* pOutSize, DataType dataType);

void CheckClientBaseMapArea(DataType dataType);

void CheckClientMapArea(uintptr_t addr, size_t size, nn::svc::MemoryPermission perm);
void CheckClientMapArea(DataType dataType);

