﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_MemoryState.h"
#include "util_TestProcess.h"
#include "util_TestLoader.h"
#include "util_TestIpc.h"
#include "util_TestMemory.h"
#include "util_MemoryState.h"

namespace {
} // namespace

extern char BinMemoryState_begin[];
extern char BinMemoryState_end[];

TestMemoryStateProcess::TestMemoryStateProcess()
    : m_PortManager(MemoryStateProcessName, 1),
      m_IsEnd(false)
{
    nn::Result result;
    uintptr_t begin = reinterpret_cast<uintptr_t>(BinMemoryState_begin);
    uintptr_t end = reinterpret_cast<uintptr_t>(BinMemoryState_end);
    TestLoader loader(BinMemoryState_begin, end - begin);
    loader.SpawnProcess(&m_ProcessHandle);
    loader.StartProcess(m_ProcessHandle);
    m_Is64Bit = loader.Is64Bit();

    nn::svc::Handle namedPort = m_PortManager.GetHandle();
    int32_t index;
    result = nn::svc::WaitSynchronization(&index, &namedPort, 1, -1);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::AcceptSession(&m_ServerSession, namedPort);
    NN_ASSERT_RESULT_SUCCESS(result);
}

TestMemoryStateProcess::~TestMemoryStateProcess()
{
    Close();
}

void TestMemoryStateProcess::Close()
{
    nn::Result result;
    if (m_IsEnd)
    {
        result = nn::svc::CloseHandle(m_ServerSession);
        return;
    }

    m_IsEnd = true;

    TestTag tag = TestTag_End;
    ServerSendData(m_ServerSession, &tag, sizeof(tag));

    WaitProcess(m_ProcessHandle);

    result = nn::svc::CloseHandle(m_ProcessHandle);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(m_ServerSession);
    NN_ASSERT_RESULT_SUCCESS(result);
}

void TestMemoryStateProcess::GetMemoryArea(
        uint64_t* pAddr, uint64_t* pSize, nn::svc::MemoryState state)
{
    TestTag tag = TestTag_Allocate;
    ServerSendData(m_ServerSession, &tag, sizeof(tag));
    ServerSendData(m_ServerSession, &state, sizeof(state));
    ServerReceiveData(pAddr, sizeof(uint64_t), m_ServerSession);
    ServerReceiveData(pSize, sizeof(uint64_t), m_ServerSession);
}

void TestMemoryStateProcess::GetNormalArea(uint64_t* pAddr, uint64_t size)
{
    TestTag tag = TestTag_GetNormal;
    ServerSendData(m_ServerSession, &tag, sizeof(tag));
    ServerSendData(m_ServerSession, &size, sizeof(size));
    ServerReceiveData(pAddr, sizeof(uint64_t), m_ServerSession);
}

void TestMemoryStateProcess::FreeMemoryArea()
{
    TestTag tag = TestTag_Free;
    ServerSendData(m_ServerSession, &tag, sizeof(tag));
}

void TestMemoryStateProcess::SetUncached(uint64_t addr, uint64_t size)
{
    TestTag tag = TestTag_SetUncached;
    ServerSendData(m_ServerSession, &tag, sizeof(tag));
    ServerSendData(m_ServerSession, &addr, sizeof(addr));
    ServerSendData(m_ServerSession, &size, sizeof(size));

    // シグナルとして受け取るだけで、値に意味はない
    ServerReceiveData(&addr, sizeof(addr), m_ServerSession);
}

void TestMemoryStateProcess::UnsetUncached(uint64_t addr, uint64_t size)
{
    TestTag tag = TestTag_UnsetUncached;
    ServerSendData(m_ServerSession, &tag, sizeof(tag));
    ServerSendData(m_ServerSession, &addr, sizeof(addr));
    ServerSendData(m_ServerSession, &size, sizeof(size));

    // シグナルとして受け取るだけで、値に意味はない
    ServerReceiveData(&addr, sizeof(addr), m_ServerSession);
}

