﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/TargetConfigs/build_Compiler.h>
#include <cstring>

extern "C" void nnMain();

namespace {

} // namespace


TEST(UnmapProcessMemory, NoMapTest)
{
    nn::Result result;

    TestProcess process(1);
    nn::svc::Handle processHandle = process.GetHandle();

    size_t size = 0x1000;
    uintptr_t toAddr = g_FreeAreaBegin;
    uintptr_t fromAddr = process.GetCodeAddress();

    // TEST 117-51
    // マップされていない領域を指定すると失敗する
    result = nn::svc::UnmapProcessMemory(toAddr, processHandle, fromAddr, size);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
}

TEST(UnmapProcessMemory, InvalidCombinationTest)
{
    nn::Result result;

    TestProcess process(3);
    nn::svc::Handle processHandle = process.GetHandle();

    size_t size = 0x1000;
    uintptr_t toAddr = g_FreeAreaBegin;
    uintptr_t fromAddr = process.GetCodeAddress();

    result = nn::svc::MapProcessMemory(toAddr, processHandle, fromAddr, size);
    ASSERT_RESULT_SUCCESS(result);

    // 1 ページ分飛ばす
    result = nn::svc::MapProcessMemory(
            toAddr + size * 2, processHandle, fromAddr + size * 2, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 117-52
    // fromAddr と toAddr が違う組み合わせだと失敗する
    result = nn::svc::UnmapProcessMemory(toAddr + size * 2, processHandle, fromAddr, size);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidRegion());

    result = nn::svc::UnmapProcessMemory(toAddr, processHandle, fromAddr + size * 2, size);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidRegion());

    result = nn::svc::UnmapProcessMemory(
            toAddr + size * 2, processHandle, fromAddr + size * 2, size);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::UnmapProcessMemory(toAddr, processHandle, fromAddr, size);
    ASSERT_RESULT_SUCCESS(result);
}

TEST(UnmapProcessMemory, ReleasePartOfMappedAreaTest)
{
    nn::Result result;

    TestProcess process(2);
    nn::svc::Handle processHandle = process.GetHandle();

    size_t size = 0x1000;
    uintptr_t toAddr = g_FreeAreaBegin;
    uintptr_t fromAddr = process.GetCodeAddress();

    result = nn::svc::MapProcessMemory(toAddr, processHandle, fromAddr, size * 2);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 117-53
    // マップされている領域の一部分を解放することが出来る
    result = nn::svc::UnmapProcessMemory(toAddr + size, processHandle, fromAddr + size, size);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::UnmapProcessMemory(toAddr, processHandle, fromAddr, size);
    ASSERT_RESULT_SUCCESS(result);
}

