﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestIpc.h"
#include "test_TransferMemory_Server.h"
#include <nn/init.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
    InitTestMemory();

    nn::Result result;

    nn::svc::Handle clientSession;

    result = nn::svc::ConnectToNamedPort(&clientSession, TransferPortName);
    NN_ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose cSessionCloser(clientSession);

    nn::svc::MemoryInfo info;

    nn::svc::Handle transferHandle;
    ReceiveMoveHandleFromServer(&transferHandle, clientSession);

    nn::svc::Handle writableEvent;
    ReceiveMoveHandleFromServer(&writableEvent, clientSession);

    nn::svc::MemoryPermission perm = nn::svc::MemoryPermission_None;
    uintptr_t addr = g_FreeAreaBegin;
    size_t size = 0x1000;
    result = nn::svc::MapTransferMemory(transferHandle, addr, size, perm);
    NN_ASSERT_RESULT_SUCCESS(result);

    GetMemoryInfo(&info, addr);
    NN_ASSERT(info.state == nn::svc::MemoryState_Transfered);
    NN_ASSERT(info.permission == nn::svc::MemoryPermission_ReadWrite);
    NN_ASSERT(info.attribute == 0);

    result = nn::svc::CloseHandle(transferHandle);
    NN_ASSERT_RESULT_SUCCESS(result);

    GetMemoryInfo(&info, addr);
    NN_ASSERT(info.state == nn::svc::MemoryState_Transfered);
    NN_ASSERT(info.permission == nn::svc::MemoryPermission_ReadWrite);
    NN_ASSERT(info.attribute == 0);

    result = nn::svc::SignalEvent(writableEvent);
    NN_ASSERT_RESULT_SUCCESS(result);
}

