﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/os.h>

namespace {
char g_Buffer[2][DefaultStackSize] __attribute__((aligned(0x1000)));
volatile uint64_t g_Thread1;
volatile uint64_t g_Thread2;
volatile bool g_Loop;
const uint64_t SleepTime = 100 * 1000 * 1000;

void IncThread(uintptr_t arg)
{
    AutoThreadExit autoExit;
    NN_UNUSED(arg);

    while(g_Loop)
    {
        if (arg == 0)
        {
            g_Thread1++;
        }
        else
        {
            g_Thread2++;
        }
    }
}

}

TEST(TestPriority, TimeSlice)
{
    for (int32_t idealCore = 0; idealCore < NumCore; idealCore++)
    {
        TestThreadLeak leakTest;

        uintptr_t pc = reinterpret_cast<uintptr_t>(IncThread);
        uintptr_t sp = reinterpret_cast<uintptr_t>(g_Buffer) + DefaultStackSize * 3;
        uint32_t priority = GetTimeSlicePriority(idealCore) - 1;
        TestThread thread1(pc, 0, sp, priority, idealCore);
        TestThread thread2(pc, 1, sp - DefaultStackSize, priority, idealCore);

        g_Thread1 = 0;
        g_Thread2 = 0;
        g_Loop = true;

        thread1.Start();
        thread2.Start();

        for (int i = 0; i < 3; i++)
        {
            nn::svc::SleepThread(SleepTime);
            ASSERT_TRUE(g_Thread1 == 0 || g_Thread2 == 0);
        }
        ASSERT_TRUE(!(g_Thread1 == 0 && g_Thread2 == 0));
        ASSERT_TRUE(g_Thread1 == 0 || g_Thread2 == 0);

        auto result = nn::svc::SetThreadPriority(thread1.GetHandle(), GetTimeSlicePriority(idealCore));
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::SetThreadPriority(thread2.GetHandle(), GetTimeSlicePriority(idealCore));
        ASSERT_RESULT_SUCCESS(result);

        uint64_t thread1Value = g_Thread1;
        uint64_t thread2Value = g_Thread2;

        for (int i = 0; i < 3; i++)
        {
            nn::svc::SleepThread(SleepTime);
            if (g_Thread1 != thread1Value && g_Thread2 != thread2Value)
            {
                break;
            }
        }
        ASSERT_TRUE(g_Thread1 != thread1Value && g_Thread2 != thread2Value);

        g_Loop = false;
        thread1.Wait();
        thread2.Wait();
    }
}

