﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//
// 手作業でテストする際に有効にするフラグ
//

// #define TEST_BY_HAND
// #define INVALID_POINTER_TEST
// #define INVALID_MEMORY_ACCESS_TEST
// #define WAIT_LOCK_FOREVER
// #define ENABLE_KERNEL_PANIC
// #define ENABLE_DEBUG_PRINT

//
// 初期プロセス化するときに有効になるフラグ
//

// 初期プロセスとしてビルドされるときにビルドルールで定義されます。
// #define INITIAL_PROGRAM_TEST

#ifdef INITIAL_PROGRAM_TEST
#define TEST_INFINIT_LOOP
#define DISABLE_LOG_MANAGER
#define ENABLE_LEAK_TEST
#define ENABLE_OUT_OF_RESOURCE_TEST
#define SUPPORT_MMC_TEST
#define SUPPORT_SDCARD_TEST
#define ENABLE_MAX_HANDLE_TEST
#endif

//
// カーネルの対応後有効にするフラグ
//

// #define SUPPORT_BREAK_DETAIL_INFO
#define SUPPORT_CAPABILITY
#define ENABLE_ASLR
#define ENABLE_PAGE_ROLLBACK
// #define ENABLE_CREATE_PROCESS_STATIC_MAP
// #define SUPPORT_LIGHT_IPC_RESULT
#define SUPPORT_IPC_LOCKED
#define SUPPORT_ALIAS_CODE_DATA
// #define SUPPORT_IPC_WITH_STATIC
#define SUPPORT_RESULT_TOO_LARGE_MESSAGE
// #define SUPPORT_RESULT_CREATE_DEVICE_ADDRESS_SPACE
#define FIX_IPC_SHARED_CODE
// #define FIX_MAP_PROCESS_CODE_MEMORY_LARGE_AREA

//
// 実装はしてあるが、無効にしてあるもの
//

// カーネルのヒープを消費しきった状態で、スレッドを作成しようとするとカーネルパニックになる
// このシーケンスには来ない想定
// #define EXHAUST_HEAP_TEST

// リプライ後クライアントが受信する前というシーケンスがテストできる環境を作ることが出来たら実施
// #define SEND_ASYNC_REPLY_TEST

