﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestProcess.h"
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include <cstring>

namespace {
} // namespace

TEST(TerminateProcess, HandleTest)
{
    TestProcessLeak leakTest;
    nn::Result result;

    nn::Bit32 flag[DefaultCapabilityFlagNum];
    SetDefaultCapability(flag, DefaultCapabilityFlagNum);
    TestProcess process(1, 0, flag, DefaultCapabilityFlagNum);
    nn::svc::Handle processHandle = process.GetHandle();

    AssignExitCode(processHandle, process.GetCodeAddress(), process.GetCodeAreaSize());

    // TEST 123-3
    // 実行前のプロセスを受け付けない
    result = nn::svc::TerminateProcess(processHandle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidState());

    process.Start();

    process.Wait();

    // 実行後のプロセスを受け付ける
    result = nn::svc::TerminateProcess(processHandle);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 123-4
    // Close したプロセスを受け付けない
    result = nn::svc::CloseHandle(processHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::TerminateProcess(processHandle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 123-5
    // INVALID_HANDLE_VALUE を受け付けない
    result = nn::svc::TerminateProcess(nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 123-7
    // スレッドの擬似ハンドルを受け付けない
    result = nn::svc::TerminateProcess(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

#ifdef TEST_BY_HAND
    // TEST 123-6
    // プロセスの擬似ハンドルを受け付ける
    result = nn::svc::TerminateProcess(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    //終了するので帰ってこない
#endif


}

