﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_Tick.h>
#include <nn/svc/svc_HardwareParamsSelect.h>

/* TEST 9-1 */
/* SleepThread に与えた引数以上の時間スリープするかを確認する */
TEST(SleepThread, Test0)
{
    TestThreadLeak leakTest;
    for (int64_t ns = 0; ns < 10 * 1000ll * 1000ll * 1000ll; ns = (ns ? (ns * 2) : 1))
    {
        volatile int64_t before = nn::svc::GetSystemTick();
        nn::svc::SleepThread(ns);
        volatile int64_t after = nn::svc::GetSystemTick();

        ASSERT_TRUE(((after - before) / (NN_HW_TICKS_PER_SECOND / (1000 * 1000)) * 1000) >= ns);
    }
}

