﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <cstring>

namespace {
}
extern "C" void nnMain();



// TEST 115-29 から 115-35
// permission のテスト
// 正常系
TEST(SetProcessMemoryPermission, Test0)
{
    TestProcessLeak testProcessLeak;
    nn::Result result;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    const nn::svc::MemoryPermission perm[] =
    {
        nn::svc::MemoryPermission_None,
        nn::svc::MemoryPermission_Read,
        nn::svc::MemoryPermission_Write,
        nn::svc::MemoryPermission_Execute,
        nn::svc::MemoryPermission_ReadWrite,
        nn::svc::MemoryPermission_ReadExecute,
        nn::svc::MemoryPermission_DontCare
    };

    for (int i = 0; i < static_cast<int>(sizeof(perm) / sizeof(*perm)); i++)
    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = 0x00200000;
        param.memoryNumPages = 1;
        param.flags          = 0x00000000;

        nn::Bit32 flags[DefaultCapabilityFlagNum];
        SetDefaultCapability(flags, DefaultCapabilityFlagNum);
        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000, perm[i]);
        switch (perm[i])
        {
            case nn::svc::MemoryPermission_None:
            case nn::svc::MemoryPermission_Read:
            case nn::svc::MemoryPermission_ReadWrite:
            case nn::svc::MemoryPermission_ReadExecute:
                {
                    ASSERT_RESULT_SUCCESS(result);
                    result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress);
                    ASSERT_RESULT_SUCCESS(result);
                    ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
                    ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
                    ASSERT_TRUE(blockInfo.permission == perm[i]);
                    ASSERT_TRUE(blockInfo.state == (perm[i] == nn::svc::MemoryPermission_ReadWrite)? nn::svc::MemoryState_Normal: nn::svc::MemoryState_Code);
                }
                break;

            case nn::svc::MemoryPermission_Write:
            case nn::svc::MemoryPermission_Execute:
            case nn::svc::MemoryPermission_DontCare:
                {
                    ASSERT_RESULT_FAILURE(result);
                    result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress);
                    ASSERT_RESULT_SUCCESS(result);
                    ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
                    ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
                    ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
                    ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);
                }
                break;
            default: FAIL();
        }
        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}

