﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>
#include <nn/os.h>

namespace {
char g_Buffer1[DefaultStackSize] __attribute__((aligned(0x1000)));
char g_Buffer2[DefaultStackSize] __attribute__((aligned(0x1000)));

volatile nn::Bit32 g_Value;
volatile nn::Bit32 g_Value1;
nn::Bit32 g_handleArray[3] = {};

void TestPriorityInheritanceConditionVariableThread(uintptr_t arg);

void TestPriorityInheritanceConditionVariable(uintptr_t x)
{
    nn::Result result;
    int32_t pri0;

    if (x == 0)
    {
        nn::svc::Handle handle;
        g_handleArray[0] = nn::os::GetCurrentThread()->_handle;
        result = nn::svc::GetThreadPriority(&pri0, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[0]), 32);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::CreateThread(&handle, reinterpret_cast<uintptr_t>(TestPriorityInheritanceConditionVariableThread), 1, reinterpret_cast<uintptr_t>(g_Buffer1 + sizeof(g_Buffer1)), 32, 0);
        ASSERT_RESULT_SUCCESS(result);
        g_handleArray[1] = static_cast<nnHandle>(handle).value;

        result = nn::svc::CreateThread(&handle, reinterpret_cast<uintptr_t>(TestPriorityInheritanceConditionVariableThread), 2, reinterpret_cast<uintptr_t>(g_Buffer2 + sizeof(g_Buffer2)), 35, 0);
        ASSERT_RESULT_SUCCESS(result);
        g_handleArray[2] = static_cast<nnHandle>(handle).value;
    }

    if (x == 0)
    {
        // 待ちスレッドがいない
        uint32_t key = 0xdeadbeef;
        nn::svc::SignalProcessWideKey(reinterpret_cast<uintptr_t>(&key), 1);
        ASSERT_TRUE(key == 0xdeadbeef);

        // cvKeyは何でもよい
        nn::svc::SignalProcessWideKey(0xdeadbeef, 1);

        nn::svc::SignalProcessWideKey(reinterpret_cast<uintptr_t>(&key), -1);
        ASSERT_TRUE(key == 0xdeadbeef);

        nn::svc::SignalProcessWideKey(reinterpret_cast<uintptr_t>(&key), 0);
        ASSERT_TRUE(key == 0xdeadbeef);
    }

    if (x == 0)
    {
        g_Value = (g_handleArray[1] | nn::svc::Handle::WaitMask);
        result = nn::svc::StartThread(static_cast<nn::svc::Handle>(g_handleArray[1]));
        ASSERT_RESULT_SUCCESS(result);

        g_Value1 = (g_handleArray[2] | nn::svc::Handle::WaitMask);
        result = nn::svc::StartThread(static_cast<nn::svc::Handle>(g_handleArray[2]));
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 1)
    {
        ASSERT_TRUE(g_Value == (g_handleArray[1] | nn::svc::Handle::WaitMask));
        result = nn::svc::WaitProcessWideKeyAtomic(reinterpret_cast<uintptr_t>(&g_Value), 0xdeadbeef, g_handleArray[1], -1);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(g_Value == g_handleArray[1]);
    }

    if (x == 2)
    {
        ASSERT_TRUE(g_Value1 == (g_handleArray[2] | nn::svc::Handle::WaitMask));
        result = nn::svc::WaitProcessWideKeyAtomic(reinterpret_cast<uintptr_t>(&g_Value1), 0xbabeface, g_handleArray[2], 100);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());
        ASSERT_TRUE(g_Value1 == 0);
        g_Value1 = (g_handleArray[2] | nn::svc::Handle::WaitMask);
        result = nn::svc::WaitProcessWideKeyAtomic(reinterpret_cast<uintptr_t>(&g_Value1), 0xbabeface, g_handleArray[2], -1);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 138-16
        // 待機が解除されたときに、addr で指定されるアドレスに、0 が格納されていたら、
        // newValue の値を addr で指定されるアドレスに書き込む
        ASSERT_TRUE(g_Value1 == g_handleArray[2]);
    }

    if (x == 0)
    {
        nn::svc::SleepThread(100 * 1000 * 1000);
        // TEST 138-14
        //  カレントスレッドの待機列に誰もいない状態で呼び出すとき、
        // ArbitrateUnlock の振る舞いと同じ振る舞いをする
        ASSERT_TRUE(g_Value == 0);
        g_Value = g_handleArray[0];

        // TEST 138-19
        // プロセスの待機列で待っているスレッドに関連して優先度逆転は起こらない
        int32_t pri;
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);

        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[1]), 33);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);

        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[1]), 31);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);

        // TEST 138-15
        // 待機が解除されたときに、addr で指定されるアドレスに、
        // スレッドのハンドル値が格納されていたら、ArbitrateLock と同じ振る舞いをする

        // x == 1 のスレッドがg_Value待ちに遷移
        ASSERT_TRUE(g_Value == g_handleArray[0]);
        nn::svc::SignalProcessWideKey(0xdeadbeef, 1);
        ASSERT_TRUE(g_Value == (g_handleArray[0] | nn::svc::Handle::WaitMask));

        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 31);

        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[1]), 33);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);

        nn::svc::SleepThread(100 * 1000 * 1000);

        // x == 2 のスレッドがg_Value1, 0xbabeface待ちに遷移
        nn::svc::SignalProcessWideKey(0xbabeface, 1);

        nn::svc::SleepThread(100 * 1000 * 1000);
    }

    if (x == 2)
    {
        result = nn::svc::WaitProcessWideKeyAtomic(reinterpret_cast<uintptr_t>(&g_Value1), 0xbabeface, g_handleArray[2], -1);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidState());
        // x == 1がオーナーのまま終了したため
    }

    if (x == 0)
    {
        // x == 1 のスレッドを起こす
        result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value));
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 1)
    {
        ASSERT_TRUE(g_Value1 == 0);
        g_Value1 = g_handleArray[1];

        // x == 2を起こす
        nn::svc::SignalProcessWideKey(0xbabeface, 1);

        // g_Value1 を持ったまま終了する。
    }

    if (x == 0)
    {
        nn::svc::Handle handle(g_handleArray[1]);
        int32_t index;
        result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 0)
    {
        nn::svc::Handle handle(g_handleArray[2]);
        int32_t index;
        result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 0)
    {
        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[0]), pri0);
        ASSERT_RESULT_SUCCESS(result);
    }
} // NOLINT (readability/fn_size)

void TestPriorityInheritanceConditionVariableThread(uintptr_t arg)
{
    AutoThreadExit autoExit;
    TestPriorityInheritanceConditionVariable(arg);
}

}

TEST(PriorityInheritanceConditionVariable, Test0)
{
    nn::Result result;

    {
        nn::svc::Handle handle;
        TestPriorityInheritanceConditionVariable(0);
    }
}


