﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>
#include <nn/os.h>

namespace {
char g_Buffer1[DefaultStackSize] __attribute__((aligned(0x1000)));
char g_Buffer2[DefaultStackSize] __attribute__((aligned(0x1000)));

volatile nn::Bit32 g_Value;
volatile nn::Bit32 g_Value1;
nn::Bit32 g_handleArray[3] = {};

void TestPriorityInheritanceLockThread(uintptr_t arg);

void TestPriorityInheritanceLock(uintptr_t x)
{
    nn::Result result;
    int32_t pri0;

    if (x == 0)
    {
        nn::svc::Handle handle;
        g_handleArray[0] = nn::os::GetCurrentThread()->_handle;
        result = nn::svc::GetThreadPriority(&pri0, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[0]), 32);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::CreateThread(&handle, reinterpret_cast<uintptr_t>(TestPriorityInheritanceLockThread), 1, reinterpret_cast<uintptr_t>(g_Buffer1 + sizeof(g_Buffer1)), 32, 0);
        ASSERT_RESULT_SUCCESS(result);
        g_handleArray[1] = static_cast<nnHandle>(handle).value;

        result = nn::svc::CreateThread(&handle, reinterpret_cast<uintptr_t>(TestPriorityInheritanceLockThread), 2, reinterpret_cast<uintptr_t>(g_Buffer2 + sizeof(g_Buffer2)), 32, 0);
        ASSERT_RESULT_SUCCESS(result);
        g_handleArray[2] = static_cast<nnHandle>(handle).value;
    }

    if (x == 0)
    {
        // 待ちスレッドがいない
        g_Value = (g_handleArray[0] | nn::svc::Handle::WaitMask);
        result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value));
        ASSERT_RESULT_SUCCESS(result);

        // TEST 137-9
        // カレントスレッドの待機列上で addr をキーとして待機しているスレッドがいない場合、
        // addr で指定されるアドレスに Bit32 値 0 を書き込む
        ASSERT_TRUE(g_Value == 0);
    }

    if (x == 0)
    {
        g_Value = (g_handleArray[0] | nn::svc::Handle::WaitMask);
        result = nn::svc::StartThread(static_cast<nn::svc::Handle>(g_handleArray[1]));
        ASSERT_RESULT_SUCCESS(result);

        g_Value1 = (g_handleArray[1] | nn::svc::Handle::WaitMask);
        result = nn::svc::StartThread(static_cast<nn::svc::Handle>(g_handleArray[2]));
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 1)
    {
        // TEST 135-17
        // addr で指定されるアドレスに格納されている Bit32 の値が、
        // thread の値と 0x40000000 のビットごとの OR を取った Bit32 値と一致すると、
        // 待機が解除されるのを待つ
        ASSERT_TRUE(g_Value == (g_handleArray[0] | nn::svc::Handle::WaitMask));
        result = nn::svc::ArbitrateLock(nn::svc::Handle(g_handleArray[0] & ~nn::svc::Handle::WaitMask), reinterpret_cast<uintptr_t>(&g_Value), (g_handleArray[1] | nn::svc::Handle::WaitMask));
        ASSERT_RESULT_SUCCESS(result);

        // TEST 135-18
        // 待機が解除され、このシステムコールを呼び出しているスレッドの待機列上に
        // addr をキーとして待機しているスレッドが存在していない場合、
        // newValue の値を addr で指定されるアドレスに書き込まれる
        ASSERT_TRUE(g_Value == (g_handleArray[1] | nn::svc::Handle::WaitMask));
    }

    if (x == 2)
    {

        // TEST 135-17
        // addr で指定されるアドレスに格納されている Bit32 の値が、
        // thread の値と 0x40000000 のビットごとの OR を取った Bit32 値と一致すると、
        // 待機が解除されるのを待つ

        ASSERT_TRUE(g_Value1 == (g_handleArray[1] | nn::svc::Handle::WaitMask));
        result = nn::svc::ArbitrateLock(nn::svc::Handle(g_handleArray[1] & ~nn::svc::Handle::WaitMask), reinterpret_cast<uintptr_t>(&g_Value1), (g_handleArray[2] | nn::svc::Handle::WaitMask));
        ASSERT_RESULT_SUCCESS(result);

        // TEST 135-18
        // 待機が解除され、このシステムコールを呼び出しているスレッドの待機列上に
        // addr をキーとして待機しているスレッドが存在していない場合、
        // newValue の値を addr で指定されるアドレスに書き込まれる
        ASSERT_TRUE(g_Value1 == (g_handleArray[2] | nn::svc::Handle::WaitMask));
    }

    if (x == 0)
    {
        nn::svc::SleepThread(100 * 1000 * 1000);

        int32_t pri;
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);

        // TEST 135-20
        // ロックで待機しているスレッドの優先度をロックを確保しているスレッドよりも下げても、
        // ロックを確保しているスレッドの優先度は変わらない
        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[1]), 33);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);

        // TEST 135-21
        // ロックで待機しているスレッドの優先度をロックを確保しているスレッドよりも高くすると、
        // ロックを確保しているスレッドの優先度が同じ優先度になる
        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[1]), 31);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 31);

        // TEST 135-22
        // スレッドが3つあり、それぞれ A ←B←C( ロック確保←解除待ち) の関係にあるとき、
        // C の優先度が上がることによって、A, B の優先度が C と同じ優先度になる
        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[2]), 30);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[1]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 30);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 30);

        result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value));
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[0]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 32);
    }

    if (x == 1)
    {
        int32_t pri;
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[1]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 30);

        result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value1));
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadPriority(&pri, static_cast<nn::svc::Handle>(g_handleArray[1]));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(pri == 31);
        nn::svc::SleepThread(100 * 1000 * 1000);
    }




    if (x == 0)
    {
        nn::svc::Handle handle(g_handleArray[1]);
        int32_t index;
        result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 0)
    {
        nn::svc::Handle handle(g_handleArray[2]);
        int32_t index;
        result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }

    if (x == 0)
    {
        result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(g_handleArray[0]), pri0);
        ASSERT_RESULT_SUCCESS(result);
    }
} // NOLINT (readability/fn_size)

void TestPriorityInheritanceLockThread(uintptr_t arg)
{
    AutoThreadExit autoExit;
    TestPriorityInheritanceLock(arg);
}

}

TEST(PriorityInheritanceLock, Test0)
{
    nn::Result result;

    result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value) + 1);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidAddress());
    result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value) + 2);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidAddress());
    result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Value) + 3);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidAddress());

    {
        nn::svc::Handle handle;
        TestPriorityInheritanceLock(0);
    }
}


