﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>
#include <cstring>
#include <nn/svc/svc_Tcb.h>

namespace {
struct TestData
{
    nn::svc::Handle writableEvent;
    nn::svc::Handle readableEvent;
};
}

TEST(ManageNamedPort, Test0)
{
    TestNamedPortLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::Handle handle1;
    uintptr_t addr;
    char* name;
    size_t size;

    // TEST 113-1
    // MemoryPermission_ReadWrite の領域を指定すると成功する
    // ローカル変数
    result = nn::svc::ManageNamedPort(&handle, "test", 1);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 113-17
    // 同じ名前のポートは登録できない
    result = nn::svc::ManageNamedPort(&handle1, "test", 1);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidState());

    // TEST 113-30
    // 登録を削除する前にハンドルを閉じることが出来る
    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 113-18
    // maxSessions は 0 を受け付ける
    result = nn::svc::ManageNamedPort(&handle1, "test", 0);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(handle1 == nn::svc::Handle(0));

    // TEST 113-19
    // maxSessions = 0 で登録が削除された名前付きポートをもう一度登録削除することは出来ない
    result = nn::svc::ManageNamedPort(&handle1, "test", 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    size = 0x00200000;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 113-1
    // MemoryPermission_ReadWrite の領域を指定すると成功する
    // ヒープ
    ::std::strcpy(reinterpret_cast<char*>(addr), "test1");
    name = reinterpret_cast<char*>(addr);
    result = nn::svc::ManageNamedPort(&handle, name, 1);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 113-18
    // maxSessions は 0 を受け付ける
    result = nn::svc::ManageNamedPort(&handle1, "test1", 0);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(handle1 == nn::svc::Handle(0));

    // TEST 113-19
    // maxSessions = 0 で登録が削除された名前付きポートをもう一度登録削除することは出来ない
    result = nn::svc::ManageNamedPort(&handle1, "test1", 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    // TEST 113-31
    // 登録を削除した後にハンドルを閉じることが出来る
    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 113-9
    // アルファベットや数字以外の文字も受け付ける
    // ギリギリ後ろの領域でも大丈夫
    name = reinterpret_cast<char*>(addr + size - 6);
    name[0] = '1';
    name[1] = '2';
    name[2] = '3';
    name[3] = '4';
    name[4] = '5';
    name[5] = '\0';
    result = nn::svc::ManageNamedPort(&handle, name, 1);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::ManageNamedPort(&handle1, name, 0);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(handle1 == nn::svc::Handle(0));

    // TEST 113-8
    // NUL 文字終端している文字列を指定することが出来る
    // "" 文字列はOK
    result = nn::svc::ManageNamedPort(&handle, name + 5, 1);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::ManageNamedPort(&handle1, name + 5, 0);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(handle1 == nn::svc::Handle(0));

    // TEST 113-28
    // 不正アクセス
    // maxSessions = 1
    name = reinterpret_cast<char*>(addr + size - 6);
    name[0] = '1';
    name[1] = '2';
    name[2] = '3';
    name[3] = '4';
    name[4] = '5';
    name[5] = '6';
    result = nn::svc::ManageNamedPort(&handle, name, 1);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());

    // TEST 113-29
    // 不正アクセス
    // maxSessions = 0
    result = nn::svc::ManageNamedPort(&handle1, name, 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
}

