﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Thread.h>

#if !defined(NN_SDK_BUILD_RELEASE)

namespace {

const char* TestString[] = {"First\n", "Second\n"};
const size_t TestStringIndex[] = {6, 7};

char g_Buffer[2][0x2000] __attribute__((aligned(0x1000)));

void OutputDebugStringTest(uintptr_t arg)
{
    AutoThreadExit autoExit;
    for(int i = 0; i < 10; i++)
    {
        nn::svc::OutputDebugString(TestString[arg], TestStringIndex[arg]);
    }
}

} // namespace

/* TEST 34-8 */
/* 複数コアで同時にOutputDebugString を読んだ場合でも、出力がされる*/
TEST(OutputDebugString, MultiCoreTest)
{
    nn::Result result;
    nn::svc::Handle handle[2];
    uintptr_t pc = reinterpret_cast<uintptr_t>(OutputDebugStringTest);
    uintptr_t sp;

    if(NumCore < 2)
    {
        return;
    }

    for(int i = 0; i < 2; i++)
    {
        sp = reinterpret_cast<uintptr_t>(&g_Buffer[i]) + 0x2000;
        result = nn::svc::CreateThread(&handle[i], pc, i, sp,
                TestLowestThreadPriority, i);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::StartThread(handle[i]);
    }

    for(int i = 0; i < 2; i++)
    {
        int32_t index;
        result = nn::svc::WaitSynchronization(&index, &handle[i], 1, -1);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(handle[i]);
        ASSERT_RESULT_SUCCESS(result);
    }
}

#endif // !defined(NN_SDK_BUILD_RELEASE)

