﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <cstring>

namespace {
}
extern "C" void nnMain();




// TEST 116-59
// MemoryState_Code の領域のどこであっても、マップすることが出来る
TEST(MapProcessMemory, NormalTest)
{
    TestProcessLeak testProcessLeak;
    nn::Result result;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = 0x00200000;
        param.memoryNumPages = 0x00000003;
        param.flags          = 0x00000000;

        nn::Bit32 flags[DefaultCapabilityFlagNum];
        SetDefaultCapability(flags, DefaultCapabilityFlagNum);
        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
        ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
        ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
        ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

        {
            result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
            ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
            // TEST 116-55
            // マップされた fromAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 116-56
            // マップされた fromAddr の領域が MemoryState_Code である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(0xFFFF8001), g_FreeAreaBegin);
            ASSERT_TRUE(blockInfo.baseAddress == g_FreeAreaBegin);
            ASSERT_TRUE(blockInfo.size == 0x1000);
            // TEST 116-57
            // マップされた toAddr の領域が MemoryPermission_ReadWrite である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
            // TEST 116-58
            // マップされた toAddr の領域が MemoryState_SharedCode である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_SharedCode);
            TEST_RW(g_FreeAreaBegin);

            result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
            ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
            // TEST 117-54
            // 解放された formAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 117-55
            // マップされた fromAddr の領域が MemoryState_Code である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(0xFFFF8001), g_FreeAreaBegin);
            // TEST 117-56
            // マップされた toAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 117-57
            // マップされた toAddr の領域が MemoryState_Free である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Free);
            TEST_NA(g_FreeAreaBegin);
        }

        {
            result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x1000, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x1000);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
            ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
            // TEST 116-55
            // マップされた fromAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 116-56
            // マップされた fromAddr の領域が MemoryState_Code である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(0xFFFF8001), g_FreeAreaBegin);
            ASSERT_TRUE(blockInfo.baseAddress == g_FreeAreaBegin);
            ASSERT_TRUE(blockInfo.size == 0x1000);
            // TEST 116-57
            // マップされた toAddr の領域が MemoryPermission_ReadWrite である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
            // TEST 116-58
            // マップされた toAddr の領域が MemoryState_SharedCode である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_SharedCode);
            TEST_RW(g_FreeAreaBegin);

            result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x1000, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x1000);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
            ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
            // TEST 117-54
            // 解放された formAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 117-55
            // マップされた fromAddr の領域が MemoryState_Code である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(0xFFFF8001), g_FreeAreaBegin);
            // TEST 117-56
            // マップされた toAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 117-57
            // マップされた toAddr の領域が MemoryState_Free である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Free);
            TEST_NA(g_FreeAreaBegin);
        }

        {
            result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x2000, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x2000);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
            ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
            // TEST 116-55
            // マップされた fromAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 116-56
            // マップされた fromAddr の領域が MemoryState_Code である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(0xFFFF8001), g_FreeAreaBegin);
            ASSERT_TRUE(blockInfo.baseAddress == g_FreeAreaBegin);
            ASSERT_TRUE(blockInfo.size == 0x1000);
            // TEST 116-57
            // マップされた toAddr の領域が MemoryPermission_ReadWrite である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
            // TEST 116-58
            // マップされた toAddr の領域が MemoryState_SharedCode である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_SharedCode);
            TEST_RW(g_FreeAreaBegin);

            result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x2000, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0x2000);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
            ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
            // TEST 117-54
            // 解放された formAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 117-55
            // マップされた fromAddr の領域が MemoryState_Code である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

            result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(0xFFFF8001), g_FreeAreaBegin);
            // TEST 117-56
            // マップされた toAddr の領域が MemoryPermission_None である
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
            // TEST 117-57
            // マップされた toAddr の領域が MemoryState_Free である
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Free);
            TEST_NA(g_FreeAreaBegin);
        }

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }

} // NOLINT (readability/fn_size)

