﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <cstring>
#include <nn/svc/svc_BaseId.autogen.h>

TEST(GetInfo, NormalTest)
{
    nn::Result result;
    nn::Bit64 coreMask;

    result = nn::svc::GetInfo(&coreMask, nn::svc::InfoType_CoreMask, static_cast<nn::svc::Handle>(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS), 0);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(coreMask != 0);
    ASSERT_TRUE(coreMask == ((1ull << NumCore) - 1));


    result = nn::svc::GetInfo(&coreMask, nn::svc::InfoType_CoreMask, static_cast<nn::svc::Handle>(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS), 1);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCombination());

    result = nn::svc::GetInfo(&coreMask, nn::svc::InfoType_CoreMask, static_cast<nn::svc::Handle>(0), 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    result = nn::svc::GetInfo(&coreMask, static_cast<nn::svc::InfoType>(-1), static_cast<nn::svc::Handle>(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS), 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidEnum());
}

